/*
 * Decompiled with CFR 0.152.
 */
package woolpack.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancer<C, R, E extends Exception, E1 extends Exception>
implements Fn<C, R, E> {
    private final Fn<Object, ? extends Fn<? super C, ? extends R, ? extends E>, ? extends E1> factory;
    private final int length;
    private final Semaphore[] semaphoreArray;
    private final List<Fn<? super C, ? extends R, ? extends E>> fnList;
    private int position = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadBalancer(Fn<Object, ? extends Fn<? super C, ? extends R, ? extends E>, ? extends E1> factory, int length) throws E1 {
        if (length < 1) {
            throw new IllegalArgumentException("length must be equals or more than 1 but " + length);
        }
        this.factory = factory;
        this.length = length;
        this.semaphoreArray = new Semaphore[length];
        this.fnList = new ArrayList<Fn<? super C, ? extends R, ? extends E>>(length);
        int i = 0;
        while (i < length) {
            this.semaphoreArray[i] = new Semaphore(1);
            Fn<Object, Fn<Object, Fn<Object, R, E>, E1>, E1> fn = factory;
            synchronized (fn) {
                this.fnList.add(factory.exec(null));
            }
            ++i;
        }
    }

    @Override
    public R exec(C c) throws E {
        int i = this.position;
        while (true) {
            if (i < this.length) {
                if (this.semaphoreArray[i].tryAcquire()) {
                    try {
                        R r = this.fnList.get(i).exec(c);
                        return r;
                    }
                    finally {
                        this.semaphoreArray[i].release();
                        this.position = (i + 1) % this.length;
                    }
                }
                Thread.yield();
                ++i;
                continue;
            }
            i = 0;
        }
    }

    public int getLength() {
        return this.length;
    }

    public Fn<Object, ? extends Fn<? super C, ? extends R, ? extends E>, ? extends E1> getFactory() {
        return this.factory;
    }
}

