/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import java.util.Collection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.el.GettingEL;
import woolpack.fn.Fn;
import woolpack.html.SelectedValueUpdater;
import woolpack.utils.Utils;
import woolpack.xml.NodeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueUpdater<E extends Exception>
implements Fn<NodeContext, Void, E> {
    private static final String VALUE = "value";
    private static final String SELECTED = "selected";
    private static final String CHECKED = "checked";
    private static final String TRUE = "true";
    private GettingEL valueEL;
    private GettingEL mapEL;
    private boolean selectFlag;
    private final SelectedValueUpdater defaultReturnable;

    public ValueUpdater(GettingEL valueEL, GettingEL mapEL, boolean selectFlag) {
        this.valueEL = valueEL;
        this.mapEL = mapEL;
        this.selectFlag = selectFlag;
        this.defaultReturnable = new SelectedValueUpdater(valueEL, mapEL);
    }

    private void executeAttrValue(NodeContext context, Element e) {
        Object value = this.valueEL.getValue(context);
        if (value != null) {
            e.setAttribute(VALUE, value.toString());
        }
    }

    private void executeOption(NodeContext context, Element e) {
        if (this.selectFlag) {
            if (this.contains(context, e)) {
                e.setAttribute(SELECTED, TRUE);
            } else {
                e.removeAttribute(SELECTED);
            }
        } else {
            this.executeAttrValue(context, e);
        }
    }

    private boolean contains(NodeContext context, Element e) {
        String value = e.getAttribute(VALUE);
        Collection collection = Utils.toCollection(this.valueEL.getValue(context));
        for (Object o : collection) {
            if (!o.toString().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Void exec(NodeContext context) {
        Element e = (Element)context.getNode();
        String elementName = e.getNodeName();
        if ("OPTION".equals(elementName)) {
            this.executeOption(context, e);
        } else if ("SELECT".equals(elementName)) {
            Node n = e.getFirstChild();
            while (n != null) {
                if (n.getNodeType() == 1 && "OPTION".equals(n.getNodeName())) {
                    this.executeOption(context, (Element)n);
                }
                n = n.getNextSibling();
            }
        } else if ("INPUT".equals(elementName)) {
            String inputType = e.getAttribute("type");
            if (!"file".equals(inputType) && !"image".equals(inputType)) {
                if (this.selectFlag) {
                    if ("radio".equals(inputType) || "checkbox".equals(inputType)) {
                        if (this.contains(context, e)) {
                            e.setAttribute(CHECKED, TRUE);
                        } else if (e.hasAttribute(CHECKED)) {
                            e.removeAttribute(CHECKED);
                        }
                    } else {
                        this.executeAttrValue(context, e);
                    }
                } else {
                    this.executeAttrValue(context, e);
                }
            }
        } else if ("BUTTON".equals(elementName)) {
            this.executeAttrValue(context, e);
        } else {
            this.defaultReturnable.exec(context);
        }
        return null;
    }

    public GettingEL getMapEL() {
        return this.mapEL;
    }

    public void setMapEL(GettingEL mapEL) {
        this.mapEL = mapEL;
        this.defaultReturnable.setValueEL(mapEL);
    }

    public boolean isSelectFlag() {
        return this.selectFlag;
    }

    public void setSelectFlag(boolean selectFlag) {
        this.selectFlag = selectFlag;
    }

    public GettingEL getValueEL() {
        return this.valueEL;
    }

    public void setValueEL(GettingEL valueEL) {
        this.valueEL = valueEL;
        this.defaultReturnable.setValueEL(valueEL);
    }
}

