/*
 * Decompiled with CFR 0.152.
 */
package woolpack.factory;

import java.util.concurrent.ConcurrentMap;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentMapCache<C, K, E extends Exception>
implements Fn<C, Object, E> {
    private Fn<? super C, ? extends ConcurrentMap<? super K, Object>, ? extends E> mapGetter;
    private Fn<? super C, ? extends K, ? extends E> keyGetter;
    private Fn<? super C, ?, ? extends E> maker;

    public ConcurrentMapCache(Fn<? super C, ? extends ConcurrentMap<? super K, Object>, ? extends E> mapGetter, Fn<? super C, K, ? extends E> keyGetter, Fn<? super C, ?, ? extends E> maker) {
        this.mapGetter = mapGetter;
        this.keyGetter = keyGetter;
        this.maker = maker;
    }

    @Override
    public Object exec(C c) throws E {
        Object value;
        ConcurrentMap<K, Object> map = this.mapGetter.exec(c);
        K key = this.keyGetter.exec(c);
        while ((value = map.get(key)) == null) {
            value = this.maker.exec(c);
            map.putIfAbsent(key, value);
        }
        return value;
    }

    public Fn<? super C, ? extends K, ? extends E> getKeyGetter() {
        return this.keyGetter;
    }

    public void setKeyGetter(Fn<? super C, ? extends K, ? extends E> keyGetter) {
        this.keyGetter = keyGetter;
    }

    public Fn<? super C, ?, ? extends E> getMaker() {
        return this.maker;
    }

    public void setMaker(Fn<? super C, ?, ? extends E> maker) {
        this.maker = maker;
    }

    public Fn<? super C, ? extends ConcurrentMap<? super K, Object>, ? extends E> getMapGetter() {
        return this.mapGetter;
    }

    public void setMapGetter(Fn<? super C, ? extends ConcurrentMap<? super K, Object>, ? extends E> mapGetter) {
        this.mapGetter = mapGetter;
    }
}

