/* 
 * Copyright (C) 2001-2006 Jacek Sieka, arnetheduck on gmail point com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"
#include "../client/DCPlusPlus.h"
#include "Resource.h"

#include "MiscPage.h"
#include "../client/SettingsManager.h"
#include "../client/IgnoreManager.h"
#include "../client/version.h"
#include "WinUtil.h"

PropPage::TextItem MiscPage::texts[] = {
	{ IDC_MISC_APPEARANCE, ResourceManager::SETTINGS_APPEARANCE },
	{ IDC_TIME_AWAY, ResourceManager::SET_SECONDARY_AWAY },
	{ IDC_ADV_MISC, ResourceManager::SETTINGS_ADVANCED4 },
	{ IDC_THOLD_STR, ResourceManager::THRESHOLD },
	{ IDC_BUFFER_STR, ResourceManager::BUFFERSIZE },
	{ IDC_IGNORE_ADD, ResourceManager::ADD },
	{ IDC_IGNORE_REMOVE, ResourceManager::REMOVE },
	{ IDC_IGNORE_CLEAR, ResourceManager::IGNORE_CLEAR },
	{ IDC_MISC_IGNORE, ResourceManager::IGNORED_USERS },
	{ IDC_USE_ANTIVIR, ResourceManager::USE_ANTIVIR },
	{ IDC_ANTIVIR_BROWSE, ResourceManager::BROWSE },
	{ IDC_IGNORE_USE_REGEXP_OR_WC, ResourceManager::USE_REGEXP_OR_WC },
	{ 0, ResourceManager::SETTINGS_AUTO_AWAY }
};

PropPage::Item MiscPage::items[] = {
	{ IDC_SECONDARY_AWAY_MESSAGE, SettingsManager::SECONDARY_AWAY_MESSAGE, PropPage::T_STR },
	{ IDC_TIME_AWAY, SettingsManager::AWAY_TIME_THROTTLE, PropPage::T_BOOL },
	{ IDC_AWAY_START_TIME, SettingsManager::AWAY_START, PropPage::T_INT },
	{ IDC_AWAY_END_TIME, SettingsManager::AWAY_END, PropPage::T_INT }, 
	{ IDC_THOLD, SettingsManager::USER_THERSHOLD, PropPage::T_INT },
	{ IDC_BUFFERSIZE, SettingsManager::CHATBUFFERSIZE, PropPage::T_INT },
	{ IDC_USE_ANTIVIR, SettingsManager::USE_ANTIVIR, PropPage::T_BOOL },
	{ IDC_ANTIVIR_PATH, SettingsManager::ANTIVIR_PATH, PropPage::T_STR },
	{ IDC_ANTIVIR_PARAMS, SettingsManager::ANTIVIR_PARAMS, PropPage::T_STR },
	{ IDC_IGNORE_USE_REGEXP_OR_WC, SettingsManager::IGNORE_USE_REGEXP_OR_WC, PropPage::T_BOOL },
	{ 0, 0, PropPage::T_END }
};

LRESULT MiscPage::onInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	PropPage::translate((HWND)(*this), texts);
	PropPage::read((HWND)*this, items);

	timeCtrlBegin.Attach(GetDlgItem(IDC_AWAY_START_TIME));
	timeCtrlEnd.Attach(GetDlgItem(IDC_AWAY_END_TIME));

	timeCtrlBegin.AddString(CTSTRING(MIDNIGHT));
	timeCtrlEnd.AddString(CTSTRING(MIDNIGHT));
	for (int i = 1; i < 12; ++i)
	{
		timeCtrlBegin.AddString((Text::toT(Util::toString(i)) + CTSTRING(AM)).c_str());
		timeCtrlEnd.AddString((Text::toT(Util::toString(i)) + CTSTRING(AM)).c_str());
	}
	timeCtrlBegin.AddString(CTSTRING(NOON));
	timeCtrlEnd.AddString(CTSTRING(NOON));
	for (int i = 1; i < 12; ++i)
	{
		timeCtrlBegin.AddString((Text::toT(Util::toString(i)) + CTSTRING(PM)).c_str());
		timeCtrlEnd.AddString((Text::toT(Util::toString(i)) + CTSTRING(PM)).c_str());
	}

	timeCtrlBegin.SetCurSel(SETTING(AWAY_START));
	timeCtrlEnd.SetCurSel(SETTING(AWAY_END));

	timeCtrlBegin.Detach();
	timeCtrlEnd.Detach();

	CRect rc;
	
	ignoreListCtrl.Attach(GetDlgItem(IDC_IGNORELIST));
	ignoreListCtrl.GetClientRect(rc);
	ignoreListCtrl.InsertColumn(0, _T("Dummy"), LVCFMT_LEFT, (rc.Width() - 17), 0);
	ignoreListCtrl.SetExtendedListViewStyle(LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);

	ignoreList = IgnoreManager::getInstance()->getIgnoredUsers();
	for(TStringHash::iterator i = ignoreList.begin(); i != ignoreList.end(); ++i) {
		ignoreListCtrl.insert(ignoreListCtrl.GetItemCount(), *i);
	}

	fixControls();
	return TRUE;
}

LRESULT MiscPage::onFixControls(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	fixControls();
	return 0;
}

LRESULT MiscPage::onEditChange(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	if(wID == IDC_IGNORELIST_EDIT)
		::EnableWindow(GetDlgItem(IDC_IGNORE_ADD), (::GetWindowTextLength(GetDlgItem(IDC_IGNORELIST_EDIT)) > 0));
	return 0;
}

LRESULT MiscPage::onItemchangedDirectories(int /*idCtrl*/, LPNMHDR pnmh, BOOL& /*bHandled*/)
{
	NM_LISTVIEW* lv = (NM_LISTVIEW*) pnmh;
	::EnableWindow(GetDlgItem(IDC_IGNORE_REMOVE), (lv->uNewState & LVIS_FOCUSED));
	return 0;
}

LRESULT MiscPage::onIgnoreAdd(WORD /* wNotifyCode */, WORD /*wID*/, HWND /* hWndCtl */, BOOL& /* bHandled */) {
	TCHAR buf[256];
	if(GetDlgItemText(IDC_IGNORELIST_EDIT, buf, 256)) {
		pair<TStringHashIter, bool> p = ignoreList.insert(buf);
	
		if(p.second) {
			ignoreListCtrl.insert(ignoreListCtrl.GetItemCount(), buf);
		} else {
			MessageBox(CTSTRING(ALREADY_IGNORED), _T(APPNAME) _T(" ") _T(VERSIONSTRING), MB_OK);
		}
	}

	SetDlgItemText(IDC_IGNORELIST_EDIT, _T(""));
	return 0;
}

LRESULT MiscPage::onIgnoreRemove(WORD /* wNotifyCode */, WORD /*wID*/, HWND /* hWndCtl */, BOOL& /* bHandled */) {
	int i = -1;
	
	TCHAR buf[256];

	while((i = ignoreListCtrl.GetNextItem(-1, LVNI_SELECTED)) != -1) {
		ignoreListCtrl.GetItemText(i, 0, buf, 256);

		ignoreList.erase(buf);
		ignoreListCtrl.DeleteItem(i);
	}

	return 0;
}

LRESULT MiscPage::onIgnoreClear(WORD /* wNotifyCode */, WORD /*wID*/, HWND /* hWndCtl */, BOOL& /* bHandled */) {
	ignoreListCtrl.DeleteAllItems();
	ignoreList.clear();
	return 0;
}

LRESULT MiscPage::onAntiVirBrowse(WORD /* wNotifyCode */, WORD /*wID*/, HWND /* hWndCtl */, BOOL& /* bHandled */) {
	TCHAR buf[MAX_PATH];
	static const TCHAR types[] = _T("Executable Files\0*.exe\0All Files\0*.*\0");

	GetDlgItemText(IDC_ANTIVIR_PATH, buf, MAX_PATH);
	tstring x = buf;

	if(WinUtil::browseFile(x, m_hWnd, false, Text::toT(Util::getDataPath()), types) == IDOK) {
		SetDlgItemText(IDC_ANTIVIR_PATH, x.c_str());
	}
	return 0;
}

void MiscPage::fixControls() {
	bool state = (IsDlgButtonChecked(IDC_TIME_AWAY) != 0);
	::EnableWindow(GetDlgItem(IDC_AWAY_START_TIME), state);
	::EnableWindow(GetDlgItem(IDC_AWAY_END_TIME), state);
	::EnableWindow(GetDlgItem(IDC_SECONDARY_AWAY_MESSAGE), state);
	::EnableWindow(GetDlgItem(IDC_SECONDARY_AWAY_MSG), state);
	::EnableWindow(GetDlgItem(IDC_AWAY_TO), state);

	state = (IsDlgButtonChecked(IDC_USE_ANTIVIR) != 0);
	::EnableWindow(GetDlgItem(IDC_ANTIVIR_PATH), state);
	::EnableWindow(GetDlgItem(IDC_ANTIVIR_PARAMS), state);
	::EnableWindow(GetDlgItem(IDC_ANTIVIR_BROWSE), state);
}

void MiscPage::write() {
	PropPage::write((HWND)*this, items);

	timeCtrlBegin.Attach(GetDlgItem(IDC_AWAY_START_TIME));
	timeCtrlEnd.Attach(GetDlgItem(IDC_AWAY_END_TIME));
	settings->set(SettingsManager::AWAY_START, timeCtrlBegin.GetCurSel());
	settings->set(SettingsManager::AWAY_END, timeCtrlEnd.GetCurSel());
	timeCtrlBegin.Detach();
	timeCtrlEnd.Detach();

	IgnoreManager::getInstance()->putIgnoredUsers(ignoreList);

}