/* 
* Copyright (C) 2002-2003 Opera, opera@home.se
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "stdafx.h"
#include "../client/DCPlusPlus.h"
#include "Resource.h"

#include "FulAdvancedPage.h"
#include "CommandDlg.h"
#include "WebShortcutsProperties.h"

#include "../client/SettingsManager.h"
#include "../client/FavoriteManager.h"
#include "WinUtil.h"

PropPage::TextItem FulAdvancedPage::texts[] = {
	{ IDC_SETTINGS_AUTODROP, ResourceManager::SETTINGS_AUTODROP_AUTODROPSETTINGS },
	{ IDC_SETTINGS_AUTODROP_SPEED, ResourceManager::SETTINGS_AUTODROP_SPEED },
	{ IDC_SETTINGS_BPS, ResourceManager::BPS },
	{ IDC_SETTINGS_AUTODROP_INTERVAL, ResourceManager::SETTINGS_AUTODROP_INTERVAL },
	{ IDC_SETTINGS_S1, ResourceManager::S },
	{ IDC_SETTINGS_AUTODROP_ELAPSED, ResourceManager::SETTINGS_AUTODROP_ELAPSED },
	{ IDC_SETTINGS_S2, ResourceManager::S },
	{ IDC_SETTINGS_AUTODROP_INACTIVITY, ResourceManager::SETTINGS_AUTODROP_INACTIVITY },
	{ IDC_SETTINGS_S3, ResourceManager::S },
	{ IDC_SETTINGS_AUTODROP_MINSOURCES, ResourceManager::SETTINGS_AUTODROP_MINSOURCES },
	{ IDC_SETTINGS_AUTODROP_FILESIZE, ResourceManager::SETTINGS_AUTODROP_FILESIZE },
	{ IDC_SETTINGS_KB7, ResourceManager::KiB },
	{ IDC_SETTINGS_OTHER_QUEUE_OPTIONS, ResourceManager::SETTINGS_OTHER_QUEUE_OPTIONS },
	{ IDC_WEB_SHORTCUTS_ADD,		ResourceManager::ADD						},
	{ IDC_WEB_SHORTCUTS_REMOVE,		ResourceManager::REMOVE						},
	{ IDC_WEB_SHORTCUTS_PROPERTIES, ResourceManager::PROPERTIES					},
	{ IDC_SB_WEB_SHORTCUTS,			ResourceManager::SETTINGS_SB_WEB_SHORTCUTS	},
	{ 0,							ResourceManager::SETTINGS_AUTO_AWAY			}
};
PropPage::Item FulAdvancedPage::items[] = {
	{ IDC_AUTODROP_SPEED, SettingsManager::AUTODROP_SPEED, PropPage::T_INT },
	{ IDC_AUTODROP_INTERVAL, SettingsManager::AUTODROP_INTERVAL, PropPage::T_INT },
	{ IDC_AUTODROP_ELAPSED, SettingsManager::AUTODROP_ELAPSED, PropPage::T_INT },
	{ IDC_AUTODROP_INACTIVITY, SettingsManager::AUTODROP_INACTIVITY, PropPage::T_INT },
	{ IDC_AUTODROP_MINSOURCES, SettingsManager::AUTODROP_MINSOURCES, PropPage::T_INT },
	{ IDC_AUTODROP_FILESIZE, SettingsManager::AUTODROP_FILESIZE, PropPage::T_INT },
	{ 0, 0, PropPage::T_END }
};

FulAdvancedPage::ListItem FulAdvancedPage::listItems[] = {
	{ SettingsManager::AUTODROP_ALL, ResourceManager::SETTINGS_AUTODROP_ALL },
	{ SettingsManager::AUTODROP_FILELISTS, ResourceManager::SETTINGS_AUTODROP_FILELISTS },
	{ SettingsManager::AUTODROP_DISCONNECT, ResourceManager::SETTINGS_AUTODROP_DISCONNECT },
	{ 0, ResourceManager::SETTINGS_AUTO_AWAY }
};

LRESULT FulAdvancedPage::onInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	PropPage::translate((HWND)(*this), texts);
	PropPage::read((HWND)*this, items, 0, 0);
	PropPage::read((HWND)*this, items, listItems, GetDlgItem(IDC_OTHER_QUEUE_OPTIONS));
	wsList = WebShortcuts::getInstance()->copyList();

	CRect rc;
	ctrlWebShortcuts.Attach(GetDlgItem(IDC_WEB_SHORTCUTS_LIST));
	ctrlWebShortcuts.GetClientRect(rc);
	rc.right -= GetSystemMetrics(SM_CXVSCROLL);
	ctrlWebShortcuts.InsertColumn(0, CTSTRING(SETTINGS_NAME), LVCFMT_LEFT, rc.Width() / 5, 0);
	ctrlWebShortcuts.InsertColumn(1, CTSTRING(KEY), LVCFMT_LEFT, rc.Width() / 5, 1);
	ctrlWebShortcuts.InsertColumn(2, CTSTRING(URL), LVCFMT_LEFT, rc.Width() * 3 / 5, 2);
	ctrlWebShortcuts.SetExtendedListViewStyle(LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);

	for (WebShortcut::Iter i = wsList.begin(); i != wsList.end(); ++i) {
		WebShortcut* ws = *i;
		addListItem(ws);
	}

	// Do specialized reading here
		SetDlgItemText(IDC_ANTIVIR_PATH, Text::toT(SETTING(ANTIVIR_PATH)).c_str());
	return TRUE;
}

void FulAdvancedPage::write() {
	PropPage::write((HWND)*this, items, 0, 0);
	PropPage::write((HWND)*this, items, listItems, GetDlgItem(IDC_OTHER_QUEUE_OPTIONS));

	if(SETTING(AUTODROP_INTERVAL) < 1)
		settings->set(SettingsManager::AUTODROP_INTERVAL, 1);
	if(SETTING(AUTODROP_ELAPSED) < 1)
		settings->set(SettingsManager::AUTODROP_ELAPSED, 1);
	WebShortcuts::getInstance()->replaceList(wsList);
	
	TCHAR buf[256];
	GetDlgItemText(IDC_ANTIVIR_PATH, buf, 256);
	settings->set(SettingsManager::ANTIVIR_PATH, Text::fromT(buf));
}

LRESULT FulAdvancedPage::onClickedShortcuts(WORD /* wNotifyCode */, WORD wID, HWND /* hWndCtl */, BOOL& /* bHandled */) {
	if (wID == IDC_WEB_SHORTCUTS_ADD) {
		WebShortcut* ws;
		ws = new WebShortcut();
		WebShortcutsProperties wsp(wsList, ws);
		if (wsp.DoModal() == IDOK) {
			wsList.push_back(ws);
			addListItem(ws);
		} else {
			delete ws;
		}
	} else if (wID == IDC_WEB_SHORTCUTS_PROPERTIES) {
		if (ctrlWebShortcuts.GetSelectedCount() == 1) {
			int sel = ctrlWebShortcuts.GetSelectedIndex();
			WebShortcut* ws = wsList[sel];
			WebShortcutsProperties wsp(wsList, ws);
			if (wsp.DoModal() == IDOK) {
				updateListItem(sel);
			}
		}
	} else if (wID == IDC_WEB_SHORTCUTS_REMOVE) {
		if (ctrlWebShortcuts.GetSelectedCount() == 1) {
			int sel = ctrlWebShortcuts.GetSelectedIndex();
			dcassert(sel >= 0 && sel < (int)wsList.size());

			wsList.erase(find(wsList.begin(), wsList.end(), wsList[sel]));
			ctrlWebShortcuts.DeleteItem(sel);
		}
	}
	return S_OK;
}
LRESULT FulAdvancedPage::onSelChangeShortcuts(WORD /* wNotifyCode */, WORD /* wID */, HWND /* hWndCtl */, BOOL& /* bHandled */) {
	CButton cbnProp, cbnRemove;
	cbnProp.Attach(GetDlgItem(IDC_WEB_SHORTCUTS_PROPERTIES));
	cbnRemove.Attach(GetDlgItem(IDC_WEB_SHORTCUTS_REMOVE));

	dcassert(ctrlWebShortcuts.IsWindow());
	if (ctrlWebShortcuts.GetSelectedCount() == 1) {
		cbnProp.EnableWindow(TRUE);
		cbnRemove.EnableWindow(TRUE);
	} else {
		cbnProp.EnableWindow(FALSE);
		cbnRemove.EnableWindow(FALSE);
	}
	return S_OK;
}

//LRESULT FulAdvancedPage::onHelp(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/) {
//	HtmlHelp(m_hWnd, WinUtil::getHelpFile().c_str(), HH_HELP_CONTEXT, IDD_FULADVANCEDPAGE);
//	return 0;
//}

//LRESULT FulAdvancedPage::onHelpInfo(LPNMHDR /*pnmh*/) {
	//HtmlHelp(m_hWnd, WinUtil::getHelpFile().c_str(), HH_HELP_CONTEXT, IDD_FULADVANCEDPAGE);
	//return 0;
//}

LRESULT FulAdvancedPage::onKeyDown(int /*idCtrl*/, LPNMHDR pnmh, BOOL& bHandled) {
	NMLVKEYDOWN* kd = (NMLVKEYDOWN*) pnmh;
	switch(kd->wVKey) {
	case VK_INSERT:
		PostMessage(WM_COMMAND, IDC_WEB_SHORTCUTS_ADD, 0);
		break;
	case VK_DELETE:
		PostMessage(WM_COMMAND, IDC_WEB_SHORTCUTS_REMOVE, 0);
		break;
	default:
		bHandled = FALSE;
	}
	return 0;
}

LRESULT FulAdvancedPage::onBrowse(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	TCHAR buf[MAX_PATH];

	GetDlgItemText(IDC_ANTIVIR_PATH, buf, MAX_PATH);
	tstring x = buf;

	if(WinUtil::browseFile(x, m_hWnd, false) == IDOK) {
		SetDlgItemText(IDC_ANTIVIR_PATH, x.c_str());
	}
	return 0;
}

LRESULT FulAdvancedPage::onDoubleClick(int /*idCtrl*/, LPNMHDR pnmh, BOOL& /*bHandled*/) {
	NMITEMACTIVATE* item = (NMITEMACTIVATE*)pnmh;

	if(item->iItem >= 0) {
		PostMessage(WM_COMMAND, IDC_WEB_SHORTCUTS_PROPERTIES, 0);
	} else if(item->iItem == -1) {
		PostMessage(WM_COMMAND, IDC_WEB_SHORTCUTS_ADD, 0);
	}

	return 0;
}