/* 
 * Copyright (C) 2001-2005 Jacek Sieka, arnetheduck on gmail point com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BADEXEPAGE_H
#define BADEXEPAGE_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "PropPage.h"
#include "ExListViewCtrl.h"
#include "../client/HttpConnection.h"
#include "../client/File.h"

class BadExe;

class BadExeDlg : public CDialogImpl<BadExeDlg>
{
	CEdit ctrlName;
	CEdit ctrlExe;
	CEdit ctrlDescription;
public:
	string name;
	string exe;
	string description;

	enum { IDD = IDD_BADEXE_DLG };

	BEGIN_MSG_MAP(BadExeDlg)
		MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		MESSAGE_HANDLER(WM_SETFOCUS, onFocus)
		COMMAND_ID_HANDLER(IDOK, OnCloseCmd)
		COMMAND_ID_HANDLER(IDCANCEL, OnCloseCmd)
	END_MSG_MAP()

	BadExeDlg() { };

	LRESULT onFocus(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/) {
		ctrlName.SetFocus();
		return FALSE;
	}

	LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
	LRESULT onType(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT onChange(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/);

	LRESULT OnCloseCmd(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
	{
		if(wID == IDOK) {
			TCHAR buf[1024];

			if(ctrlExe.GetWindowTextLength() == 0)
			{
				MessageBox(_T("Exe must not be empty"));
				return 0;
			}

#define GET_TEXT(id, var) \
			GetDlgItemText(id, buf, 1024); \
			var = buf;

			GET_TEXT(IDC_BE_NAME, Text::toT(name));
			GET_TEXT(IDC_BE_EXE, Text::toT(exe));
			GET_TEXT(IDC_BE_DESC, Text::toT(description));
		}
		EndDialog(wID);
		return 0;
	}
};

class BadExePage : public CPropertyPage<IDD_BADEXEPAGE>, public PropPage, private HttpConnectionListener
{
public:
	BadExePage(SettingsManager *s) : PropPage(s) { 
		SetTitle(CTSTRING(BADEXE_TITLE));
	};
 
	virtual ~BadExePage() { 
		ctrlExes.Detach();
	};

	BEGIN_MSG_MAP(BadExePage)
		MESSAGE_HANDLER(WM_INITDIALOG, onInitDialog)
		COMMAND_ID_HANDLER(IDC_BADEXE_CHECK, onClickedCheck)
		COMMAND_ID_HANDLER(IDC_ADD_MENU, onAddMenu)
		COMMAND_ID_HANDLER(IDC_IMPORT_MENU, onImportMenu)
		COMMAND_ID_HANDLER(IDC_REMOVE_MENU, onRemoveMenu)
		COMMAND_ID_HANDLER(IDC_CHANGE_MENU, onChangeMenu)
		COMMAND_ID_HANDLER(IDC_MOVE_UP, onMoveUp)
		COMMAND_ID_HANDLER(IDC_MOVE_DOWN, onMoveDown)
		COMMAND_ID_HANDLER(IDC_RELOAD_CLIENTS, onReload)
		COMMAND_ID_HANDLER(IDC_UPDATE, onUpdate)
		NOTIFY_HANDLER(IDC_BADEXE_ITEMS, NM_DBLCLK, onDblClick)
		NOTIFY_HANDLER(IDC_BADEXE_ITEMS, LVN_COLUMNCLICK, onColumnClick)
	END_MSG_MAP()

	LRESULT onInitDialog(UINT, WPARAM, LPARAM, BOOL&);
	LRESULT onClickedCheck(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT onAddMenu(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT onImportMenu(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT onChangeMenu(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT onRemoveMenu(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT onMoveUp(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT onMoveDown(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT onReload(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT onUpdate(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT onDblClick(int /*idCtrl*/, LPNMHDR /* pnmh */, BOOL& bHandled) {
		return onChangeMenu(0, 0, 0, bHandled);
	}

	LRESULT onColumnClick(int /*idCtrl*/, LPNMHDR pnmh, BOOL& /*bHandled*/) {
		NMLISTVIEW* const l = (NMLISTVIEW*)pnmh;
		if(l->iSubItem == ctrlExes.getSortColumn()) {
			if (!ctrlExes.isAscending())
				ctrlExes.setSort(-1, ctrlExes.getSortType());
			else
				ctrlExes.setSortDirection(false);
		} else {
			ctrlExes.setSort(l->iSubItem, ExListViewCtrl::SORT_STRING_NOCASE);
		}
		return 0;
	}

	// Common PropPage interface
	PROPSHEETPAGE *getPSP() { return (PROPSHEETPAGE *)*this; }
	virtual void write();
	
protected:
	ExListViewCtrl ctrlExes;

	static Item items[];
	static TextItem texts[];
	
	void addEntry(const BadExe& be, int pos);
private:
//	virtual void onAction(HttpConnectionListener::Types type, HttpConnection* /*conn*/, const u_int8_t* buf, int len) throw() {
	virtual void on(HttpConnectionListener::Data, HttpConnection* /*conn*/, const uint8_t* buf, size_t len) throw() {	
			downBuf.append((char*)buf, len);
	}

//	virtual void onAction(HttpConnectionListener::Types type, HttpConnection* /*conn*/, const string& aLine) throw() {
	virtual void on(HttpConnectionListener::Complete, HttpConnection* /*conn*/, const string&) throw() {	
			if(!downBuf.empty()) {
				string fname = Util::getConfigPath() + "BadExes.xml";
				File f(fname + ".tmp", File::WRITE, File::CREATE | File::TRUNCATE);
				f.write(downBuf);
				f.close();
				File::deleteFile(fname);
				File::renameFile(fname + ".tmp", fname);
				reload();
				MessageBox(_T("Bad exes list now updated."), _T("Updated"), MB_OK);
			}
	}

	virtual void on(HttpConnectionListener::Failed, HttpConnection* conn, const string& aLine) throw() {
			tstring msg = _T("Bad exes list download failed.\r\n") + Text::toT(aLine);
			MessageBox(msg.c_str(), _T("Failed"), MB_OK);
		conn->removeListener(this);
	}

	void reload();

	HttpConnection c;
	string downBuf;
	
	void fixControls();
};

#endif //BADEXEPAGE_H

/**
 * @file
 * $Id: BadExePage.h,v 1.0 iDC++ code modified by Legolas $
 */