void HubManager::saveBadExe() {
	try {
		SimpleXML xml;

		xml.addTag("BadExes");
		xml.stepIn();

		for(BadExe::Iter k = badExes.begin(); k != badExes.end(); ++k) {
			xml.addTag("BadExe");
			xml.addChildAttrib("Name", k->getName());
			xml.addChildAttrib("Exe", k->getExe());
			xml.addChildAttrib("Description", k->getDescription());
		}
		xml.stepOut();

		string fname = Util::getAppPath() + "BadExe.xml";

		File f(fname + ".tmp", File::WRITE, File::CREATE | File::TRUNCATE);
		f.write(SimpleXML::w1252Header);
		f.write(xml.toXML());
		f.close();
		File::deleteFile(fname);
		File::renameFile(fname + ".tmp", fname);

	} catch(const Exception& e) {
		dcdebug("BadExe::save: %s\n", e.getError().c_str());
	}
}

void HubManager::loadBadExe(SimpleXML* aXml) {
		dontSave = true;

		aXml->resetCurrentChild();
			if(aXml->findChild("BadExes")) {
				aXml->stepIn();
				while(aXml->findChild("BadExe")) {
					addBadExe(aXml->getChildAttrib("Name"), aXml->getChildAttrib("Exe"), 
					aXml->getChildAttrib("Description"));
				}
				aXml->stepOut();
		}

		dontSave = false;
	}


	try {
		SimpleXML xml;
		xml.fromXML(File(Util::getAppPath() + "BadExe.xml", File::READ, File::OPEN).read());
		loadBadExe(&xml);
		/*string dangerous = File(Util::getAppPath() + "dangerous.dat", File::READ, File::OPEN).read();
		while(dangerous.find("\r\n") != string::npos) {
			string s_exe = dangerous.substr(0, dangerous.find("\r\n"));
			addBadExe(Util::emptyString, s_exe, Util::emptyString);
			dangerous = dangerous.substr(dangerous.find("\r\n")+2);
		}*/
	} catch(const Exception& e) {
		dcdebug("HubManager::loadBadExe: %s\n", e.getError().c_str());
	}