package blackjack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlackJack {
    Deck deck;
    Player player;
    Player dealer;

    public BlackJack() {
        deck = new Deck();
        player = new Player(deck);
        dealer = new Player(deck);
    }

    private void display(String message) {
        System.out.println(message);
    }

    private boolean confirm(String message) {
        System.out.print(message + " [y/N]:");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        try {
            line = br.readLine();
        } catch (IOException e) {
            Logger.getLogger(BlackJack.class.getName()).log(Level.SEVERE, null, e);
        }
        return line != null && line.toLowerCase().startsWith("y");
    }

    private void displayScores() {
        display("プレーヤー：" + player.score());
        display("ディーラー：" + dealer.score());
    }

    private void displayResult() {
        switch (player.match(dealer)) {
            case WIN:
                display("あなたの勝ちです！");
                break;
            case DRAW:
                display("引き分けです。");
                break;
            case LOST:
                display("あなたの負けです！");
        }
    }

    private void init() {
        
        deck.init().shuffle();
        player.init().hit().hit();
        dealer.init().hit();
        displayScores();
        dealer.hit();
    }

    private void play() {
        // ゲームを初期化します
        init();

        while(!player.isBust()) {
            if (!confirm("もう１枚カードを引きますか？")) {
                break;
            }
            player.hit();
            display("プレイヤー（あなた）: " + player.score());
        }

        if (player.isBust()) {
            display("あなたは、バストしました...");
        }

        while (dealer.score() < 17) {
            dealer.hit();
            display("ディーラー：ヒット");
        }

        displayScores();
        displayResult();
    }

    public void start() {
        while(true) {
            play();
            if(!confirm("もう一度プレイしますか？")) {
                // Nを入力してEnterでゲーム終了。
                break;
            }
        }
    }
    
    public static void main(String[] args) {
        // ブラックジャッククラスのインスタンスを作ります。
        BlackJack blackJack = new BlackJack();
        // ゲームを開始します。
        blackJack.start();
    }
    
}
