/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: stdafx.h,v 1.2 2003/06/30 15:58:39 takayuki Exp $
 */

// stdafx.h : ɸΥƥ 󥯥롼 ե롢
//            ޤϻȲ¿Ĥޤѹʤ
//            ץѤΥ󥯥롼 ե򵭽Ҥޤ

#if !defined(AFX_STDAFX_H__D427C5C9_3DF2_4C06_BC74_B35DCF7062FC__INCLUDED_)
#define AFX_STDAFX_H__D427C5C9_3DF2_4C06_BC74_B35DCF7062FC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define STRICT
#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0400
#endif
#define _ATL_APARTMENT_THREADED

#include <atlbase.h>
// CComModule 饹饹ѤơС饤ɤ
// _Module ̾ѹʤǤ
extern CComModule _Module;
#include <atlcom.h>
#include <atlctl.h>


/*
 *  ITRONǥХå󥰥󥿥եϢ
 */

/*
 *  ǥѥå
 */
#define DSP_NORMAL		0;	//ƥȤΥǥѥå
#define DSP_NONTSKCTX	1;	//߽CPU㳰Υǥѥå 

typedef	short		 BITMASK;
typedef unsigned int INHNO;

/* ߥϥɥ */
typedef struct t_rglog_interrupt{
	int inhno;	//ߥϥɥֹ
} T_RGLOG_INTERRUPT;

/* ߥӥϥɥ(̤) */
typedef struct t_rglog_isr {
	int		isrid;	//ߥӥ롼ID
	int     inhno;	//ߥϥɥֹ
} T_RGLOG_ISR;

/* ।٥ȥϥɥ */
typedef struct t_rglog_timerhdr {
	unsigned int	type;	//ޡμ
	int             hdrid;	//।٥ȥϥɥID
	void *          exinf;	//ĥ
} T_RGLOG_TIMERHDR;

/* CPU㳰ϥɥ */
typedef struct t_rglog_cupexc {
	int		tskid;	//оݤȤʤ륿ID
} T_RGLOG_CPUEXC;

/* 㳰롼 */
typedef struct t_rglog_tskexc {
	int		tskid;	//оݤȤʤ륿ID
} T_RGLOG_TSKEXC;

/* Ѳ */
typedef struct t_rglog_tskstat {
	int		tskid;		//ID
	int		tskstat;	//西
	int		tskwait;	//Ԥ
	int		wobjid;		//ԤоݤΥ֥ID
} T_RGLOG_TSKSTAT;

/* ǥѥå㳫 */
typedef struct t_rglog_dispatch_enter {
	int				tskid;		//ID
	unsigned int	disptype;	//ǥѥå
} T_RGLOG_DISPATCH_ENTER;

/* ǥѥå㽪λ */
typedef struct t_rglog_dispatch_leave {
	int		tskid;		//ID
} T_RGLOG_DISPATCH_LEAVE;

/* ӥ */
typedef struct t_rglog_svc {
	int				fncno;		//ǽ
	unsigned int	prmcnt;		//ѥ᡼
	void *			prmary[1];	//ѥ᡼
} T_RGLOG_SVC;

/* ȡʸΤߤΥ */
typedef struct t_rglog_comment {
	unsigned int	length;		//ʸĹ
	char			strtext[1];	//ʸ(NULLü)-Ǥ
} T_RGLOG_COMMENT;

typedef struct t_rglog_header {
	unsigned int	logtype;
	unsigned int	logtim;
	unsigned int	valid;
	unsigned int	bufsz;
} T_RGLOG_HEADER;

typedef union t_rglog_body
{
	T_RGLOG_INTERRUPT		interrupt;
	T_RGLOG_ISR				isr;
	T_RGLOG_TIMERHDR		timerhdr;
	T_RGLOG_CPUEXC			cpuexc;
	T_RGLOG_TSKEXC			tskexc;
	T_RGLOG_TSKSTAT			tskstat;
	T_RGLOG_DISPATCH_ENTER	dispatch_enter;
	T_RGLOG_DISPATCH_LEAVE	dispatch_leave;
	T_RGLOG_SVC				svc;
	T_RGLOG_COMMENT			comment;
} T_RGLOG_BODY;

typedef struct DBIFLOG
{
	struct	t_rglog_header	header;
	union	t_rglog_body	body;
} DBIFLOG;

typedef struct t_rglog
{
	unsigned int logtype;
	unsigned int logtim;
	unsigned int valid;
	unsigned int bufsz;
	char		 buf[1];
} T_RGLOG;

/*
 *  μ̤
 */
#define LOG_TYP_INTERRUPT	0x01	/* ߥϥɥ */
#define LOG_TYP_ISR			0x02	/* ߥӥϥɥ */
#define LOG_TYP_TIMERHDR	0x03	/* ।٥ȥϥɥ */
#define LOG_TYP_CPUEXC		0x04	/* CPU㳰ϥɥ */
#define LOG_TYP_TSKEXC		0x05	/* 㳰롼 */
#define LOG_TYP_TSKSTAT		0x06	/* Ѳ */
#define LOG_TYP_DISPATCH	0x07	/* ǥѥå */
#define LOG_TYP_SVC			0x08	/* ӥ */
#define LOG_TYP_COMMENT		0x09	/* ȡʸΤߤΥ */
#define LOG_ENTER			0x00	/*  */
#define LOG_LEAVE			0x80	/* иλ */

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ Ԥľɲäޤ

#endif // !defined(AFX_STDAFX_H__D427C5C9_3DF2_4C06_BC74_B35DCF7062FC__INCLUDED)
