/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005 by Freelines CO.,Ltd 
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_support.S,v 1.2 2007/01/05 02:10:17 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼 ֥TK-850ES/SG2ѡ
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "v850asm.inc"

#define Set(x,y,z) Lea x, r6; Lea y, r7; st.##z r7, 0[r6]

/*
 *  ٥Υåȥƥ¸ν
 *
 *  ȥåץ⥸塼ǡν˸ƤӽФ롥
 */

	.text
	.globl hardware_init_hook
hardware_init_hook:

	/* ƥ०ȥȥ쥸5MHz4=20MHz */
	Set(VSWC,  0x01,   b)
	nop
	/* ݸ줿쥸ؤΥ
	   ץååȥ쥸ᥤ󥯥åfxx(PCC=0) */
	lea	PRCMD, r6
	lea	PCC, r7
	st.b	r0, 0[r6]
	st.b	r0, 0[r7]
	nop
	nop
	nop
	nop
	nop
	Set(PLLCTL,0x03,   b)   /* PLLȥ쥸PLLư */
	Set(WDTM2, 0x07,   b)   /* WDTM2 stop */
	/* Х */
	Set(EXIMC, 0x01,   b)	/* Х󥿡ե⡼ɥ쥸ѥ졼ȥХ */
	Set(PMC9,  0xFFFF, h)	/* P9⡼ɥȥ쥸A0-A15 */
	Set(PMCCM, 0x02,   b)	/* PCM⡼ɥȥ쥸Clock Out */
	Set(PMCCT, 0x11,   b)	/* PCT⡼ɥȥ쥸RD/WR0 */
	Set(PMCDL, 0xFFFF, h)	/* PDL⡼ɥȥ쥸AD0-AD15 */
	Set(BSC,   0x5555, h)	/* Х쥸All 16bit */
	Set(DWC0,  0x0000, h)	/* ǡ쥸wait=0 */
	Set(AWC,   0xFF00, h)	/* ɥ쥹쥸wait=0 */
	Set(BCC,   0xAA00, h)	/* Х쥸wait=0 */
	/* NIC */
	Set(PMC0,  0x10,   b)	/* P04=INTP1 */
	Set(PMCT,  0xBF,   b)	/* ASTB=out(LAN CS) */
	Set(PCT,   0x00,   b)	/* ASTB=Low out */
	Set(PM5,   0xFD,   b)	/* LAN Reset out */
	Set(P5 ,   0x00,   b)	/* LAN Reset out */

	jmp		r31



	/* ɸ߽ȥڡ */
	.macro StandardInterruptEntry name
	.globl \name
\name:
	jr	vector_handler
	nop;nop;nop;nop;nop;nop
	.endm

	.macro ReservedInterruptEntry
	nop;nop;nop;nop;nop;nop;nop;nop
	.endm

/*
 * ߥϥɥʬ
 * 		Ȥꤢս˽롣
 */

	.section	".vectors","ax"
	.align      4
	.globl      __reset
__reset:
	jr	start
	nop;nop;nop;nop;nop;nop

	StandardInterruptEntry NMI
	StandardInterruptEntry INTWDT2
	ReservedInterruptEntry 
	StandardInterruptEntry TRAP0
	StandardInterruptEntry TRAP1
	StandardInterruptEntry DBG
/*#-------------------------------------------------------------------
  #	SECURITY_ID
  #-------------------------------------------------------------------*/
/*	.section	"SECURITY_ID" */
	.word	0xffffffff	/* --0-3 byte code,Address is 0x70-0x73 */
	.word	0xffffffff	/* --4-7 byte code,Address is 0x74-0x77 */
	.hword	0xffff		/* --8-9 byte code,Address is 0x78-0x79 */
/*#-------------------------------------------------------------------
  #	OPTION_BYTES
  #-------------------------------------------------------------------*/
/*	.section	"OPTION_BYTES" */
	.hword	0x0000		/* --0-1 byte code,Address is 0x7a-0x7b */
	.hword	0x0000		/* --2-3 byte code,Address is 0x7c-0x7d */
	.hword	0x0000		/* --4-5 byte code,Address is 0x7e-0x7f */

	StandardInterruptEntry INTLVI
	StandardInterruptEntry INTP0
	StandardInterruptEntry INTP1
	StandardInterruptEntry INTP2
	StandardInterruptEntry INTP3
	StandardInterruptEntry INTP4
	StandardInterruptEntry INTP5
	StandardInterruptEntry INTP6
	StandardInterruptEntry INTP7
	StandardInterruptEntry INTTQ0OV
	StandardInterruptEntry INTTQ0CC0
	StandardInterruptEntry INTTQ0CC1
	StandardInterruptEntry INTTQ0CC2
	StandardInterruptEntry INTTQ0CC3
	StandardInterruptEntry INTTP0OV
	StandardInterruptEntry INTTP0CC0
	StandardInterruptEntry INTTP0CC1
	StandardInterruptEntry INTTP1OV
	StandardInterruptEntry INTTP1CC0
	StandardInterruptEntry INTTP1CC1
	StandardInterruptEntry INTTP2OV
	StandardInterruptEntry INTTP2CC0
	StandardInterruptEntry INTTP2CC1
	StandardInterruptEntry INTTP3OV
	StandardInterruptEntry INTTP3CC0
	StandardInterruptEntry INTTP3CC1
	StandardInterruptEntry INTTP4OV
	StandardInterruptEntry INTTP4CC0
	StandardInterruptEntry INTTP4CC1
	StandardInterruptEntry INTTP5OV
	StandardInterruptEntry INTTP5CC0
	StandardInterruptEntry INTTP5CC1
	StandardInterruptEntry INTTM0EQ0
	StandardInterruptEntry INTCB0R
	StandardInterruptEntry INTCB0T
	StandardInterruptEntry INTCB1R
	StandardInterruptEntry INTCB1T
	StandardInterruptEntry INTCB2R
	StandardInterruptEntry INTCB2T
	StandardInterruptEntry INTCB3R
	StandardInterruptEntry INTCB3T
	StandardInterruptEntry INTUA0R
	StandardInterruptEntry INTUA0T
	StandardInterruptEntry INTUA1R
	StandardInterruptEntry INTUA1T
	StandardInterruptEntry INTUA2R
	StandardInterruptEntry INTUA2T
	StandardInterruptEntry INTAD
	StandardInterruptEntry INTDMA0
	StandardInterruptEntry INTDMA1
	StandardInterruptEntry INTDMA2
	StandardInterruptEntry INTDMA3
	StandardInterruptEntry INTKR
	StandardInterruptEntry INTWTI
	StandardInterruptEntry INTWT
	StandardInterruptEntry INTC0ERR
	StandardInterruptEntry INTC0WUP
	StandardInterruptEntry INTC0REC
	StandardInterruptEntry INTC0TRX

/*
 * ɾѹǽ?
 *  (ɾѥե꡼˥󥰥ޤ餺ľܥޥ󥿤Τ)
 */
Function _vxget_tim
	Lea	TP0CNT, r7
	ld.h	0[r7], r8
	st.w	r8, 0[r6]
	mov	r0, r10
	jmp	r31
