/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.9 2003/12/04 08:25:44 honda Exp $
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

#include "api.h"

/*
 *  ͥ̾Υ͡
 */
#include "cpu_rename.h"

/*
 *  ץåü̿Υ饤ؿ
 */
#ifndef _MACRO_ONLY
#include "cpu_insn.h"
#endif /* _MACRO_ONLY */

#include "c54x.h"


#define TBIT_TCB_TSTAT      6
#define TBIT_TCB_PRIORITY   4

#ifndef _MACRO_ONLY

typedef struct task_context_block{
  VP  sp;
  FP  pc;
}CTXB;

extern UH  nest;

Inline BOOL
sense_context(void)
{
  return (nest > 0);
}

Inline BOOL
sense_lock()
{
  volatile UH temp_st1;
  temp_st1 = ST1;
  return ((temp_st1 & 0x0800) > 0);
}

#define t_sense_lock sense_lock
#define i_sense_lock sense_lock

/*
 *  CPUåȤβ
 *
 */

#define t_lock_cpu      lock_cpu
#define i_lock_cpu      lock_cpu
#define t_unlock_cpu    unlock_cpu
#define i_unlock_cpu    unlock_cpu


Inline void
lock_cpu()
{
    disint();
}

Inline void
unlock_cpu()
{
    enaint();
}

extern void dispatch(void);
extern void exit_and_dispatch(void);

extern FP  int_table[32];
extern const UH  int_mask_table[32];


Inline void
define_inh(INHNO inhno, FP inthdr)
{
  int_table[inhno] = inthdr;
}

#define INTHDR_ENTRY(inthdr) extern void inthdr(void)
#define INT_ENTRY(inthdr) inthdr

/*
 *  TMS320VC54x DSPˤCPU㳰¸ߤʤΤ
 *  ʲŬ
 */

/*
 *   CPU㳰ϥɥ
 *   ٥ơ֥Ͽ
 */   

Inline void
define_exc(EXCNO excno, FP exchdr)
{
}

/*
 *  CPU㳰ȯΥƥȽ
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
   return(TRUE);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
   return(TRUE);
}

extern void cpu_initialize(void);
extern void cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
