/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: tl16c550cfn.h,v 1.3 2003/12/04 08:25:44 honda Exp $
 */

/*
 * TL16C550CFN ʰSIOɥ饤
 */
#ifndef _TL16C550CFN_H_
#define _TL16C550CFN_H_

#include <t_config.h>

/***********************************************
 *  I/O  ꡦޥåץɡ쥸            *
***********************************************/
/*
 *  complex Programmable Logic Device (CPLD)   *
 *  I/O ꡦޥåץɡ쥸                 *
 */

/*  쥸ɥ쥹*/
#ifndef _MACRO_ONLY
volatile ioport UH	port0;
volatile ioport UH	port1;
volatile ioport UH	port2;
volatile ioport UH	port3;
volatile ioport UH	port4;
volatile ioport UH	port5;
volatile ioport UH	port6;
#endif /* _MACRO_ONLY */

/*  CPLD쥸 */
#define CPLD_CTRL1	port0
#define CPLD_STAT	port1
#define CPLD_DMCTRL	port2
#define CPLD_DBIO	port3
#define CPLD_CTRL2	port4
#define CPLD_SEM0	port5
#define CPLD_SEM1	port6

/*
 *  UART I/O ꡦޥåץɡ쥸 *
 */
/*  쥸 ɥ쥹 */
#ifndef _MACRO_ONLY
volatile ioport UH	port4000;
volatile ioport UH	port4001;
volatile ioport UH	port4002;
volatile ioport UH	port4003;
volatile ioport UH	port4004;
volatile ioport UH	port4005;
volatile ioport UH	port4006;
volatile ioport UH	port4007;
#endif /* _MACRO_ONLY */

/*  UART 쥸  */
#define UART_RBR	port4000
#define UART_THR	port4000
#define UART_IER	port4001
#define UART_IIR	port4002
#define UART_FCR	port4002
#define UART_LCR	port4003
#define UART_MCR	port4004
#define UART_LSR	port4005
#define UART_MSR	port4006
#define UART_SCR	port4007
/*
 *  ʲΥ쥸˥ˡ
 *  DLAB=1 (b7 of LCR) 򥻥åȤɬפ
 */
#define UART_DLL	port4000
#define UART_DLM	port4001

/*
 *  ӥåȥեɤ
 */
#define FCR_FIFO	0x01
#define FCR_RFRST	0x02
#define FCR_TFRST	0x04
#define FIFO_TRIG	0x00

#define LCR_DLAB	0x80

/* ߤ */
#define IER_ERBI	0x01  /*  */
#define IER_RIE		IER_ERBI 
#define IER_ETBEI	0x02  /*  */
#define IER_TIE		IER_ETBEI

#define LSR_DR		0x01
#define LSR_THRE	0x20
#define LSR_TEMT	0x40

#define IIR_RXINT	0x04
#define IIR_TXINT	0x02

/*
 *  UARTΥܡ졼Ȥ
 */
/*
 * BAUD RATE 2 : 115200 bps
 * BAUD RATE 4 : 57600  bps
 */
#define UART_BAUD_RATE    2



#ifndef _MACRO_ONLY

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block {
	VP	dummy;
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block {
	const SIOPINIB	*siopinib;  /* ꥢI/OݡȽ֥å */
	VP_INT	exinf;			/* ĥ */
	BOOL	openflag;		/* ץѤߥե饰 */
	BOOL	getready;		/* ʸ */
	BOOL	putready;		/* ʸǤ */
} SIOPCB;

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND    1u              /* ǽХå */
#define SIO_ERDY_RCV    2u              /* ΥХå */

/*
 * ͥ뵯ưѤν(sys_putcѤ뤿)
 */
extern void	uart_init(void);

/*
 *  SIOɥ饤Фν롼
 */
extern void	uart_initialize(void);

/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL	uart_openflag(void);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB	*uart_opn_por(ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void	uart_cls_por(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL	uart_snd_chr(SIOPCB *siopcb, char chr);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT	uart_rcv_chr(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void	uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void	uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  SIOγߥӥ롼
 */
extern void	uart_isr(void);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void	uart_ierdy_snd(VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void	uart_ierdy_rcv(VP_INT exinf);

/* ݡ󥰤ǥꥢ */
Inline char
uart_putc(char c)
{
	while ((UART_LSR & LSR_THRE) == 0);      /*  쥸ɤ  */
	UART_THR = c;
	return(c);
}

#endif /* _MACRO_ONLY */

#endif /* _TL16C550CFN_H_ */
