/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2006 by Witz Corporation, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: uart.h,v 1.1 2006/04/10 08:19:25 honda Exp $
 */

/*
 *  Ʊ̿ (UART)ꥢͥǥХSIO˥ɥ饤
 *  Zup-F16ĥܡѡ
 */

#ifndef _UART_H_
#define _UART_H_

/*
 * ꥢ륳ȥ쥸 
 */
/* 19200bps = (6144000*4)/4/(BRCK)/(BRS+(16-BRK)/16)/16	*/
/* BRCK=4ʬ,BRS=5,+(16-BRK)/16 ̤ */
#define	BRCR_19200  	(TBIT_SIOBRCK2 | 5)
#define	BRADD_19200		0
/* 38400bps = (6144000*4)/4/(BRCK)/(BRS+(16-BRK)/16)/16	*/
/* BRCK=1ʬ,BRS=10,+(16-BRK)/16 ̤ */
#define	BRCR_38400		(TBIT_SIOBRCK0 | 10)
#define	BRADD_38400		0
#define	INT_LEVEL_UART	5		/* ߥ٥ */

/*
 *  ꥢI/OγߥϥɥΥ٥ֹ
 */
#define	INHNO_SERIAL_IN1	INT_NO_RX1
#define	INHNO_SERIAL_OUT1	INT_NO_TX1
#define INHNO_SERIAL_IN2	INT_NO_RX0
#define INHNO_SERIAL_OUT2	INT_NO_TX0

#ifndef _MACRO_ONLY

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block {
	UH  cntrl;		/* ȥ쥸 */
	UH  hint;		/* ߥ쥸 */

	UB  pcrfc_def;		/* ǥեȤ (P9CR/P9FC) */
	UB  scmod0_def;		/* ǥեȤ (SCMOD0)	*/
	UB  sccr_def;		/* ǥեȤ (SCCR)		*/
	UB  brcr_def;		/* ǥեȤ (BRCR)		*/
	UB  bradd_def;		/* ǥեȤ (BRADD)		*/
	UB  int_clr;		/* ׵ե饰ꥢޥ	*/
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* ꥢI/OݡȽ֥å */
	VP_INT			exinf;		/* ĥ */
	INT				rxb;		/* Хåե	*/
	volatile UB		sts_flag;	/* Хåեե饰	*/
} SIOPCB;

/*
 *  Хå롼μֹ
 */
#define UART_ERDY_SND		1u			/* ǽХå			*/
#define UART_ERDY_RCV		2u			/* ΥХå			*/

/*
 *  SIOɥ饤Фν롼
 */
extern void	uart_initialize(void);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB * uart_opn_por(ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void	uart_cls_por(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL	uart_snd_chr(SIOPCB *siopcb, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT	uart_rcv_chr(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void	uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void	uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void	uart_ierdy_snd(VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void	uart_ierdy_rcv(VP_INT exinf);

#endif /* _MACRO_ONLY */
#endif /* _UART_H_ */

