/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sh7145cmt.h,v 1.5 2005/07/06 00:45:07 honda Exp $
 */

/*
 *	ޥɥ饤
 *  CMT
 */

#ifndef _SH7145CMT_H_
#define _SH7145CMT_H_

/*
 *   ޤؤϥåʬ
 *   	f/8ǥ
 */
#define TCR_CKS         0x0

/*
 *   ޤ˶뤵륯åȿ[kHz]
 *      12.288MHz*2/8 = 3,072kHz
 */
#define TIMER_CLOCK     3072


/*
 *  ͤɽη
 */
typedef UH CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)
#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define	MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE	100		/* ٤θѤ͡ñ̤ɽ */
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ȥ쥸Υɥ쥹
 */
#define CMSTR	(VH *)0xffff83d0
#define CMCSR_0	(VH *)0xffff83d2
#define CMCNT_0	(VH *)0xffff83d4
#define CMCOR_0	(VH *)0xffff83d6


#ifndef _MACRO_ONLY
/*
 *  ޥ
 */
Inline void
sh2_timer_start ()
{
	sil_wrh_mem (CMSTR, sil_reh_mem (CMSTR) | 0x0001);
}

/*
 *  ް
 */
Inline void
sh2_timer_stop ()
{
    	/* ޤ 	  */
	sil_wrh_mem (CMSTR, sil_reh_mem (CMSTR) & ~0x0001);
}

/*
 *  ޳׵Υꥢ
 *	TCR쥸IMFAӥåȤ1ɤ߽Фˣ񤭹
 */
Inline void
sh2_timer_int_clear ()
{
	/* ׵򥯥ꥢ     */
	sil_wrh_mem (CMCSR_0, sil_reh_mem (CMCSR_0) & ~0x0080);
				/* CMFڥޥåե饰Υꥢ */
}


/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
sh2_timer_initialize ()
{
	CLOCK cyc = TO_CLOCK (TIC_NUME, TIC_DENO);


	sil_wrh_mem (MSTCR2, (sil_reh_mem(MSTCR2)& ~0x0100));
	/*
	 *  ޴Ϣ
	 */
	sh2_timer_stop ();			/*  */
	/* ޾ͤΥå */
	assert (cyc <= MAX_CLOCK);

	/*  ʬ  clock 1/8  ߶ػ */
    sil_wrh_mem(CMCSR_0,0x0000);
	/*  CMCOR0쥸ʥɸ͡      */
	sil_wrh_mem (CMCOR_0,(VH)CLOCK_PER_TICK);
	/* 󥿤򥯥ꥢ             */
	sil_wrh_mem (CMCNT_0,0x0000);
	sil_wrh_mem (CMCSR_0, sil_reh_mem(CMCSR_0) | 0x0040);	/* ߵ */
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
sh2_timer_terminate ()
{
	sh2_timer_stop ();			/* ޤ     */
	sh2_timer_int_clear ();		/* ׵򥯥ꥢ */

	sil_wrh_mem (CMCSR_0, sil_reh_mem(CMCSR_0) & ~0x0040);	//Ե
	sil_wrh_mem (CMCNT_0,0x0000);
	sil_wrh_mem (CMCOR_0,0x0000);
	sil_wrh_mem (MSTCR2, (sil_reh_mem(MSTCR2) | 0x0100));
}

/*
 *  ޤθͤɽФ
 *ޤưŪߤͤɤ߽Ф
 */
Inline CLOCK
sh2_timer_get_current ()
{
	CLOCK	clk;
/* SH1Ʊ */
	sh2_timer_stop ();			/*    */

	/*  Ԥ֤٤  */

	clk = sil_reh_mem(CMCNT_0);
	sh2_timer_start();			/*  ޥ  */
	
	return(clk);
}

/*
 *  ޳׵Υå
 */
Inline BOOL
sh2_timer_fetch_interrupt ()
{
	return (sil_reh_mem (CMCSR_0) & 0x0080);
}

#endif /* _MACRO_ONLY */
#endif /* _SH7145CMT_H_ */
