/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_support.S,v 1.11 2004/09/22 08:47:52 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼 ֥KZ-SH1ѡ
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"

#ifndef GDB_STUB
/*
 *   Хơȥȥ
 */
#define	WCR1	0x5ffffa2	/*  ȥȥ쥸1 */
#define	WCR2	0x5ffffa4	/*  ȥȥ쥸2 */
#define	WCR3	0x5ffffa6	/*  ȥȥ쥸3 */

		/*  ꥢ7꡼ɥWAITˤ  	*/
		/*  ȥơ  			*/
#define    WCR1_RW7	0x8000
		/*  ꥢ3꡼ɥWAITˤ  	*/
		/*  ȥơ  			*/
#define    WCR1_RW3	0x800
		/*  ꥢ0꡼ɥWAITˤ  	*/
		/*  ȥơ  			*/
#define    WCR1_RW0	0x100
		/*  ꥢ0,21ơȥ󥰥  	*/
#define    WCR3_A02LW	0x6000



/*
 *  ٥Υåȥƥ¸ν _hardware_init_hook
 *
 *  ȥåץ⥸塼ǡν˸ƤӽФ롥
 */
	.text
	.align 2
	.global _hardware_init_hook
_hardware_init_hook:
	/*
	 *  Хơȥȥν
	 *  
	 */

	/*
	 *  ȥơȥȥ쥸WCR1
	 *  RW3 = 0
	 *  ꥢ3꡼ɥϣơȤǽλ
	 *  
	 *  RW0 = 0
	 *  ꥢ0꡼ɥWAITˤ
	 *  ȥơʤ
	 */

			/* *WCR1 &= ~(WCR1_RW3 | WCR1_RW0); */
	mov.l	_hw_hook_wcr1, r0
	mov.w	@r0, r1			/*  r1WCR1  */
	mov.w	_hw_hook_wcr1_data, r2
	and	r2, r1
	mov.w	r1, @r0			/*  WCR1r1  */
	
	
	/*
	 *  ȥơȥȥ쥸WCR3
	 *  
	 *  A02LW = 00
	 *  ꥢ0,21ơȥ󥰥
	 */
	
	mov.l	_hw_hook_wcr3, r3
	mov.w	@r3, r4			/*  r4WCR3  */
	mov.w	_hw_hook_wcr3_a02lw, r5
	and	r5, r4
	rts
	mov.w	r4, @r3			/*  WCR3r4  */

			/*  ꥢ0,21ơȥ󥰥  	*/
			/* *WCR3 &= WCR3_A02LW_MASK; */
	
	
	
	.align 2
_hw_hook_wcr1:
	.long	WCR1
_hw_hook_wcr3:
	.long	WCR3
_hw_hook_wcr1_data:	
	.word	~(WCR1_RW3 | WCR1_RW0) & 0xffff
_hw_hook_wcr3_a02lw:	
	.word	~WCR3_A02LW & 0xffff
	
#endif /* GDB_STUB */
