/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: pit.h,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *	ޥɥ饤
 *MPC860T¢μߥPIT
 */

#ifndef _PIT_H_
#define _PIT_H_

#include <mpc860_sil.h>

/*
 *  SIUߥ٥ʥӥåȥѥ
 */
#define SIU_INT_PIT	LEVEL_TO_BIT_PATTERN(INTLVL_PIT)


/*
 *  ͤɽη
 */
typedef UH	CLOCK;

/*
 *	ޤ˶뤵륯åȿ[kHz]
 *   	TIMER_CLOCK=SYSTEM_CLOCK[MHz] / 4
 */
#define	TIMER_CLOCK		(SYSTEM_CLOCK * 1000 / 4)

/*
 *  ͤɽȥߥáñ̤ȤѴ
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)
#define CLOCK_PER_TICK	((CLOCK) (TO_CLOCK(TIC_NUME, TIC_DENO) - 1))

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define	MAX_CLOCK	((CLOCK) 0xffffu)

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE	100	/* ٤θѤ͡ñ̤ɽ*/
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ȥ쥸
 */

/*  ߥơ쥸  */
#define PISCR       (VH *)(IMMR_BASE + 0x240)
#define PISCRK      (VW *)(IMMR_BASE + 0x340)  /*  쥸  */
#define PISCR_PIRQ  0xff00      /*  ׵٥ӥå  */  
#define PISCR_PS    BIT8_16     /*  ߥơ  */    
#define PISCR_PIE   BIT13_16    /*  ߥ֥͡  */
#define PISCR_PITF  BIT14_16    /*  PITե꡼֥͡  */
#define PISCR_PTE   BIT15_16    /*  ޡ֥͡  */

/*  PITȥ쥸ʾ2ХȤΤߡ  */
#define PITC        (VH *)(IMMR_BASE + 0x244)
#define PITCK       (VW *)(IMMR_BASE + 0x344)  /*  쥸  */

/*  PIT쥸ʾ2ХȤΤߡ  */
#define PITR        (VH *)(IMMR_BASE + 0x248)



#ifndef _MACRO_ONLY

/*
 *  쥸ݸΥåȥå
 */

/*  PISCRå  */
Inline void
lock_piscr()
{
    	/*  ͤUNLOCK_KEYʳǤɤ  */
    mpc860_wrw_mem(PISCRK, 0);
}

/*  PISCRå  */
Inline void
unlock_piscr()
{
    mpc860_wrw_mem(PISCRK, UNLOCK_KEY);
}

/*  PITCå  */
Inline void
lock_pitc()
{
    	/*  ͤUNLOCK_KEYʳǤɤ  */
    mpc860_wrw_mem(PITCK, 0);
}

/*  PITCå  */
Inline void
unlock_pitc()
{
    mpc860_wrw_mem(PITCK, UNLOCK_KEY);
}

/*
 *  ޥ
 */
Inline void
pit_start()
{
    unlock_piscr();         	/*  PISCRå  */
    mpc860_orh_mem(PISCR, PISCR_PTE);
    lock_piscr();         	/*  PISCRå  */
}

/*
 *  ް
 */
Inline void
pit_stop()
{
    unlock_piscr();         	/*  PISCRå  */
    mpc860_andh_mem(PISCR, ~PISCR_PTE);
    lock_piscr();         	/*  PISCRå  */
}

/*
 *  ޳׵Υꥢ
 *          PISCR쥸PSӥåȤ1񤭹
 */
Inline void
pit_int_clear()
{
	/*
	 *  SILѤȤΥǽ򥪥դ
	 */
#ifdef SIL_DEBUG
    BOOL sil_debug_tmp = sil_debug_on;
    sil_debug_on = FALSE;
#endif /* SIL_DEBUG */

    unlock_piscr();         	/*  PISCRå  */
    mpc860_orh_mem(PISCR, PISCR_PS);
    lock_piscr();         	/*  PISCRå  */

	/*
	 *  SILѤȤΥǽ
	 */
#ifdef SIL_DEBUG
    sil_debug_on = sil_debug_tmp;
#endif /* SIL_DEBUG */

}


/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
pit_initialize()
{
    VH piscr;
    VW sccr;
    
    /* ޾=ѿκͤʤΤǥåϾά */

    pit_stop();		/*  */
    
    /*
     *  ޴Ϣ
     */
    
    /*  åʬ  */
    unlock_sccr();              /*  SCCRå  */
    sccr = mpc860_rew_mem(SCCR);
    sccr = (sccr & ~SCCR_RTDIV) /*  ꥢ륿९åʬ:4  */
            | SCCR_RTSEL;       /*  åEXTCLK  */
    mpc860_wrw_mem(SCCR, sccr);
    lock_sccr();                /*  SCCRå  */


    /*  ɸ  */
    unlock_pitc();                  /*  PITCå  */
    mpc860_wrh_mem(PITC, CLOCK_PER_TICK);
    lock_pitc();                    /*  PITCå  */
    
    
    unlock_piscr();                 /*  PISCRå  */
    piscr = mpc860_reh_mem(PISCR);
    piscr = (piscr & ~PISCR_PIRQ)
            | (SIU_INT_PIT << 8)	/*  ߥ٥  */
            | PISCR_PIE;                /*  PITߵ  */
    mpc860_wrh_mem(PISCR, piscr);
    lock_piscr();                   /*  PISCRå  */
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
pit_terminate()
{
    pit_stop();				/* ޤ 	*/
    pit_int_clear();			/* ׵򥯥ꥢ */

    unlock_piscr();                 	/*  PISCRå  */
    mpc860_andh_mem(PISCR, ~PISCR_PIE);	/* ޳ߤػ   */
    lock_piscr();                   	/*  PISCRå  */
    
    /*  ϥޤؤΥåߤ  */
}

/*
 *  ޤθͤɽФ
 *߶ػ߶ǸƤӽФ
 */
Inline CLOCK
pit_get_current()
{
    CLOCK pitr;
    
    pitr = mpc860_reh_mem(PITR);
    return(CLOCK_PER_TICK - pitr);
}

/*
 *  ޳׵Υå
 */
Inline BOOL
pit_fetch_interrupt()
{
    VH piscr;
    
    /*  ɤ߽ФʤΤǡåʤɤ  */
    piscr = mpc860_reh_mem(PISCR);
    return(piscr & PISCR_PS);
}

#endif /* _MACRO_ONLY */
#endif /* _PIT_H_ */
/*  end of file  */
