/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: mpc860t.h,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *  MPC860Υϡɥ񸻤
 */

#ifndef _MPC860_H_
#define _MPC860_H_

/*
 *  ߤܿ
 */
#define TMAX_SIU_INTNO      16  /*  ƥ।󥿡ե˥åSIU  */
#define TMAX_CPM_INTNO      32  /*  ̿ץå⥸塼CPM  */
                                /*  MPC860  */
#define TMAX_INTNO          (TMAX_SIU_INTNO+TMAX_CPM_INTNO)

/*
 *  ߴϢ
 *  װ3ͤƤ
 *  ֹ
 *  SIUؤγ׵٥
 *  ٥
 *  CPMߤΤǤҤȤޤȤΰ
 *  (1) No.07ο
 *  ʹ֤ˤʬ䤹ץǤ
 *  ľܡѤʤ
 *  (1-2) װμ
 *  ٥ơ֥ΥǥåȤɤ߽Ф
 *  ʤΤǡ¨ͤȤƥޥƤɬפϤʤ
 *  ͽ2ӥåȥեȤƤ
 *  (2) 1ХȤΥӥåȥѥ 
 *  ׵٥ꤹݤ˥쥸˥åȤ
 *  1ӥåȤ򥻥åȤ
 *  SIUIPM
 *  2ХȤΥӥåȥѥ
 *  CPMߤΤǤҤȤޤȤΰ
 *  (1) ߥޥ
 *  SIUߥ쥸SIMASKꤹ
 *  ʬ٥㤤׵򤹤٤ƥޥ
 *  (2) αγװ
 *  ӥåȤåȤƤ
 *  
 *  ٥2-(1)ֹ桢ߥ٥ѥӥåȥѥ
 *  IPMˤǼ
 *  
 */

/*
 *  ֹ
 *      ϡɥޥ˥奢ˤSIUߥ1631֤ͽ
 *      ߤȤ뤬٥ơ֥뤬̵̤礭ʤʤΤǡ
 *      CPMߥƤƤ
 *      
 *      ֹͥ٤δطSIUߤCPMߡʥǥեȡ
 *      ǵդʤΤ
 *      SIU
 *      ֹ桡0Ǿ
 *      ֹ桡 15ǲ
 *      CPMߡʥǥեȡ
 *      ֹ桡 0x0ǲ
 *      ֹ桡0x1fǾ
 */

    /*  SIUߥ  */
#define INTNO_IRQ0      0x0     /*  IRQ0  */
#define INTNO_LVL0      0x1     /*  ٥0  */
#define INTNO_IRQ1      0x2     /*  IRQ1  */
#define INTNO_LVL1      0x3     /*  ٥1  */
#define INTNO_IRQ2      0x4     /*  IRQ2  */
#define INTNO_LVL2      0x5     /*  ٥2  */
#define INTNO_IRQ3      0x6     /*  IRQ3  */
#define INTNO_LVL3      0x7     /*  ٥3  */
#define INTNO_IRQ4      0x8     /*  IRQ4  */
#define INTNO_LVL4      0x9     /*  ٥4  */
#define INTNO_IRQ5      0xa     /*  IRQ5  */
#define INTNO_LVL5      0xb     /*  ٥5  */
#define INTNO_IRQ6      0xc     /*  IRQ6 */
#define INTNO_LVL6      0xd     /*  ٥6  */
#define INTNO_IRQ7      0xe     /*  IRQ7  */
#define INTNO_LVL7      0xf     /*  ٥7  */

    /*  CPMߥ  */
#define INTNO_ERR       0x10    /*  顼0x0  */
#define INTNO_PC4       0x11    /*  ѥI/O PC40x1  */
#define INTNO_PC5       0x12    /*  ѥI/O PC50x2  */
#define INTNO_SMC2      0x13    /*  SMC2/PIP0x3  */
#define INTNO_SMC1      0x14    /*  SMC10x4  */
#define INTNO_SPI       0x15    /*  SPI0x5  */
#define INTNO_PC6       0x16    /*  ѥI/O PC60x6  */
#define INTNO_TIMER4    0x17    /*  40x7  */
/*  CPMֹ8ͽѤ  */
#define INTNO_PC7       0x19    /*  ѥI/O PC70x9  */
#define INTNO_PC8       0x1a    /*  ѥI/O PC80xa  */
#define INTNO_PC9       0x1b    /*  ѥI/O PC90xb  */
#define INTNO_TIMER3    0x1c    /*  30xc  */
/*  CPMֹ0xdͽѤ  */
#define INTNO_PC10      0x1e    /*  ѥI/O PC100xe  */
#define INTNO_PC11      0x1f    /*  ѥI/O PC110xf  */
#define INTNO_I2C       0x20    /*  I2C0x10  */
#define INTNO_RISC      0x21    /*  RISCޥơ֥롧0x11  */
#define INTNO_TIMER2    0x22    /*  20x12  */
/*  CPMֹ0x13ͽѤ  */
#define INTNO_IDMA2     0x24    /*  IDMA20x14  */
#define INTNO_IDMA1     0x25    /*  IDMA10x15  */
#define INTNO_SDMA      0x26    /*  SDMAͥХ顼0x16  */
#define INTNO_PC12      0x27    /*  ѥI/O PC120x17  */
#define INTNO_PC13      0x28    /*  ѥI/O PC130x18  */
#define INTNO_TIMER1    0x29    /*  10x19  */
#define INTNO_PC14      0x2a    /*  ѥI/O PC14  */
#define INTNO_SCC4      0x2b    /*  SCC40x1a  */
#define INTNO_SCC3      0x2c    /*  SCC30x1c  */
#define INTNO_SCC2      0x2d    /*  SCC20x1d  */
#define INTNO_SCC1      0x2e    /*  SCC10x1e  */
#define INTNO_PC15      0x2f    /*  ѥI/O PC150x1f  */

/*
 *  SIUIPM
 *    2ХȤΥӥåȥѥ
 *    ϡɥΥǥեȤͥ٤˹碌Ƥ
 */
#define IPM_IRQ0	0x00u			/*  IRQ0  */
#define IPM_LVL0	BIT0_16			/*  ٥0  */
#define IPM_IRQ1	(IPM_LVL0 | BIT1_16)	/*  IRQ1  */
#define IPM_LVL1	(IPM_IRQ1 | BIT2_16)	/*  ٥1  */
#define IPM_IRQ2	(IPM_LVL1 | BIT3_16)	/*  IRQ2  */
#define IPM_LVL2	(IPM_IRQ2 | BIT4_16)	/*  ٥2  */
#define IPM_IRQ3	(IPM_LVL2 | BIT5_16)	/*  IRQ3  */
#define IPM_LVL3	(IPM_IRQ3 | BIT6_16)	/*  ٥3  */
#define IPM_IRQ4	(IPM_LVL3 | BIT7_16)	/*  IRQ4  */
#define IPM_LVL4	(IPM_IRQ4 | BIT8_16)	/*  ٥4  */
#define IPM_IRQ5	(IPM_LVL4 | BIT9_16)	/*  IRQ5  */
#define IPM_LVL5	(IPM_IRQ5 | BIT10_16)	/*  ٥5  */
#define IPM_IRQ6	(IPM_LVL5 | BIT11_16)	/*  IRQ6  */
#define IPM_LVL6	(IPM_IRQ6 | BIT12_16)	/*  ٥6  */
#define IPM_IRQ7	(IPM_LVL6 | BIT13_16)	/*  IRQ7  */
#define IPM_LVL7	(IPM_IRQ7 | BIT14_16)	/*  ٥7  */


/*  ߥ٥뤫ֹؤѴ  */
#define _LEVEL_TO_INHNO(level)      INTNO_LVL##level
#define  LEVEL_TO_INHNO(level)      _LEVEL_TO_INHNO(level)

/*  ߥ٥뤫ϿѥӥåȥѥؤѴ  */
#define _LEVEL_TO_BIT_PATTERN(level)      (0x1<<(7-(level)))
#define  LEVEL_TO_BIT_PATTERN(level)      _LEVEL_TO_BIT_PATTERN(level)

/*  ߥ٥뤫IPMؤѴ  */
#define _LEVEL_TO_IPM(level)      IPM_LVL##level
#define  LEVEL_TO_IPM(level)      _LEVEL_TO_IPM(level)

/*  ߥ٥뤫ߵĥӥåȤؤѴ  */
#define _LEVEL_TO_ENABLE_BIT(level)  SIMASK_LVM##level
#define  LEVEL_TO_ENABLE_BIT(level)  _LEVEL_TO_ENABLE_BIT(level)


/*
 *  CPU쥸
 */

/*
 *   8. ̿ᥭå塦ǡåϢ
 */

/*  쥸 */

/*  ̿ᥭåϢ */
#define IC_CST	560	/*  椪ӥơ쥸 */
#define IC_ADR	561	/*  ɥ쥹쥸  */
#define IC_DAT	562	/*  ǡݡȡ쥸  */

/*  ǡåϢ */
#define DC_CST	568	/*  椪ӥơ쥸 */
#define DC_ADR	569	/*  ɥ쥹쥸  */
#define DC_DAT	570	/*  ǡݡȡ쥸  */

/*
 *   9. ˥åMMUϢ
 */
/*  쥸  */
#define MI_CTR	784	/*  IMMU 쥸  */
#define MD_CTR	792	/*  DMMU 쥸  */

/*  TLB쥸  */
#define MI_EPN	787	/*  IMMU ¸ڡֹ쥸  */
#define MD_EPN	795	/*  DMMU ¸ڡֹ쥸  */
#define MI_TWC	789	/*  IMMU ơ֥륦쥸  */
#define MD_TWC	797	/*  DMMU ơ֥륦쥸  */
#define MI_RPN	790	/*  IMMU ¡ʪ˥ڡֹݡ  */
#define MD_RPN	798	/*  DMMU ¡ʪ˥ڡֹݡ  */

/*  ơ֥륦١쥸  */
#define M_TWD	796	/*  MMU ơ֥륦١쥸  */

/*  ݸ쥸  */
#define M_CASID	793	/*  MMU ȡɥ쥹ID 쥸  */
#define MI_AP	786	/*  IMMU ݸ쥸  */
#define MD_AP	794	/*  DMMU ݸ쥸  */

/*  å쥸  */
#define M_TB	799	/*  MMU ơ֥륦ڥ롦쥸  */

/*  ǥХå쥸  */
#define MI_CAM	816	/*  IMMU CAM ȥꡦ꡼ɡ쥸  */
#define MI_RAM0	817	/*  IMMU RAM ȥꡦ꡼ɡ쥸 0  */
#define MI_RAM1	818	/*  IMMU RAM ȥꡦ꡼ɡ쥸 1  */
#define MD_CAM	824	/*  DMMU CAM ȥꡦ꡼ɡ쥸  */
#define MD_RAM0	825	/*  DMMU RAM ȥꡦ꡼ɡ쥸 0  */
#define MD_RAM1	826	/*  DMMU RAM ȥꡦ꡼ɡ쥸 1  */

/*
 *  11. ƥ।󥿡ե˥åSIUϢ
 */


/*
 *  ޥåץ쥸
 *  쥸Ƭɥ쥹
 *  
 *  ꥻåľ0x0000,0000ϤؤƤ뤬SDRAM
 *  ֤ĤΤǡ̤Υɥ쥹Ѥɬפ
 */
#define IMMR        638                 /*  쥸ֹ  */
#define IMMR_UPPER_2BYTE  0xff00              /*  16ӥå  */
#define IMMR_BASE   (IMMR_UPPER_2BYTE << 16)  /*  ١ɥ쥹  */  

#define TADR_SIU_SIUMCR  0x0    /* SIU⥸塼륳ե졼 */
                                /*                     쥸SIUMCR  */

/*
 *  11.5 SIUߥȥϢ
 */
#define TADR_SIU_SIPEND 0x10    /* SIUα쥸SIPEND */
#define TADR_SIU_SIMASK 0x14    /* SIUߥޥ쥸SIMASK */

				/*  2ХȤΤ߻Ѥ  */
#define SIMASK		(VH *)(IMMR_BASE + TADR_SIU_SIMASK)
#define SIMASK_IRM0	BIT0_16		/*  IRQ0  */
#define SIMASK_LVM0	BIT1_16		/*  ٥0  */
#define SIMASK_IRM1	BIT2_16		/*  IRQ1  */
#define SIMASK_LVM1	BIT3_16		/*  ٥1  */
#define SIMASK_IRM2	BIT4_16		/*  IRQ2  */
#define SIMASK_LVM2	BIT5_16		/*  ٥2  */
#define SIMASK_IRM3	BIT6_16		/*  IRQ3  */
#define SIMASK_LVM3	BIT7_16		/*  ٥3  */
#define SIMASK_IRM4	BIT8_16		/*  IRQ4  */
#define SIMASK_LVM4	BIT9_16		/*  ٥4  */
#define SIMASK_IRM5	BIT10_16	/*  IRQ5  */
#define SIMASK_LVM5	BIT11_16	/*  ٥5  */
#define SIMASK_IRM6	BIT12_16	/*  IRQ6  */
#define SIMASK_LVM6	BIT13_16	/*  ٥6  */
#define SIMASK_IRM7	BIT14_16	/*  IRQ7  */
#define SIMASK_LVM7	BIT15_16	/*  ٥7  */

#define TADR_SIU_SIEL   0x18    /* SIUߥå٥쥸SIEL */
#define TADR_SIU_SIVEC  0x1c    /* SIUߥ٥쥸SIVEC */
#define TADR_SIU_TESR   0x20    /* ž顼ơ쥸TESR */
#define TADR_SIU_SDCR   0x30    /* SDMAե졼쥸SDCR */

/*
 *  11.7 եȥåɥå޴Ϣ
 */
#define TADR_SIU_SYPCR   0x4    /* ƥݸȥ쥸SYPCR */
#define SYPCR_SWE 	 BIT29_32  /*  ֥͡  */
#define SYPCR_SWRI 	 BIT30_32  /*  ꥻåȡ  */ 
#define TADR_SIU_SWSR    0xe       /* եȥӥ쥸SWSR */
#define SWSR_CLEAR1      0x556c    /* ꥢ˽񤭹 */
#define SWSR_CLEAR2      0xaa39    /* ꥢ˽񤭹 */

/*
 *  12 ꥻåȴϢ
 */
#define TADR_SIU_RSR  0x288  /* ꥻåȡơ쥸RSR */
#define TADR_SIU_RSRK 0x388  /* ꥻåȡơ쥸 */
#define RSR_EHRS BIT0_32    /* ϡɡꥻåȡơ */
#define RSR_ESRS BIT1_32    /* եȡꥻåȡơ */
#define RSR_LLRS BIT2_32    /* åꥻåȡơ */
#define RSR_SWRS BIT3_32    /* եȥåɥåꥻå */
#define RSR_CSRS BIT4_32    /* åȥåסꥻåȡơ */
    		/* ǥХåݡȡϡɡꥻåȡơ */
#define RSR_DBHRS BIT5_32
    		/* ǥХåݡȡեȡꥻåȡơ */
#define RSR_DBSRS BIT6_32
#define RSR_JTRS BIT4_32    /* JTAGꥻåȡơ */


/*
 *  ̿ץå⥸塼CPMϢ
 */

/*
 *  35. CPMߥȥϢ
 */
#define TADR_CPM_CIVR   0x930   /* CPMߥ٥쥸CIVR */
#define TADR_CPM_CICR   0x940   /* CPMߥե졼 */
                                /*                   쥸CICR  */
#define TADR_CPM_CIPR   0x944   /* CPMα쥸CIPR */
#define TADR_CPM_CIMR   0x948   /* CPMߥޥ쥸CIMR */
#define TADR_CPM_CISR   0x94c   /* CPMߥ󥵡ӥ쥸CISR */

/* CPMߥե졼 쥸CICR */
#define CICR            (VW *)(IMMR_BASE + TADR_CPM_CICR)
#define CICR_IEN        BIT24_32

/* CPMߥޥ쥸CIMR */
#define CIMR            (VW *)(IMMR_BASE + TADR_CPM_CIMR)
#define CIMR_PC15       BIT0_32     
#define CIMR_SCC1       BIT1_32     
#define CIMR_SCC2       BIT2_32     
#define CIMR_SCC3       BIT3_32     
#define CIMR_SCC4       BIT4_32     
#define CIMR_PC14       BIT5_32     
#define CIMR_TIMER1     BIT6_32     
#define CIMR_PC13       BIT7_32     
#define CIMR_PC12       BIT8_32     
#define CIMR_SDMA       BIT9_32     
#define CIMR_IDMA1      BIT10_32        
#define CIMR_IDMA2      BIT11_32        
#define CIMR_TIMER2     BIT13_32        
#define CIMR_RTT        BIT14_32        
#define CIMR_I2C        BIT15_32        
#define CIMR_PC11       BIT16_32        
#define CIMR_PC10       BIT17_32        
#define CIMR_TIMER3     BIT19_32        
#define CIMR_PC9        BIT20_32        
#define CIMR_PC8        BIT21_32        
#define CIMR_PC7        BIT22_32        
#define CIMR_TIMER4     BIT24_32        
#define CIMR_PC6        BIT25_32        
#define CIMR_SPI        BIT26_32        
#define CIMR_SMC1       BIT27_32        
#define CIMR_SMC2       BIT28_32        
#define CIMR_PC5        BIT29_32        
#define CIMR_PC4        BIT30_32        

/* CPMߥ󥵡ӥ쥸CISR */
#define CISR            (VW *)(IMMR_BASE + TADR_CPM_CISR)
#define CISR_BIT(device)	_CISR_BIT(device)
#define _CISR_BIT(device)	CIMR_##device

/*
 *  CPMӥåȤ
 */
    /*  CPMߥ٥쥸CIVR쥸IACKӥå  */
#define TA_CPM_CIVR_IACK    0x1 


/*
 *  15. åϢΥ쥸
 */

/*  ƥ९åӥꥻå쥸  */
#define TADR_SCCR   0x280
#define SCCR        (VW *)(IMMR_BASE + TADR_SCCR)
#define TADR_SCCRK  0x380       /*  쥸  */
#define SCCRK       (VW *)(IMMR_BASE + TADR_SCCRK)

#define SCCR_RTDIV  BIT7_32     /*  ꥢ륿९åʬ  */
                                /*  04ʬ1512ʬ  */
#define SCCR_RTSEL  BIT8_32     /*  ꥢ륿९å  */
                                /*  0OSCMʿ徽졼ˡ1EXTCLK  */
#define SCCR_CRQEN  BIT9_32     /*  CPM׵ᥤ֥͡  */
#define SCCR_PRQEN  BIT10_32    /*  ѥޥͥ׵ᥤ֥͡  */
#define SCCR_EBDF   (BIT13_32 | BIT14_32)   /*  Хʬ  */
#define SCCR_DFBRG  (BIT19_32 | BIT20_32)   /*  BRGCLKʬ  */

/*  SPLL ϡӥꥻå쥸  */
#define TADR_PLPRCRK    0x384   /*  쥸  */
#define TADR_PLPRCR     0x284   
#define PLPRCR_TIMIST   BIT19_32    /*  ޳ߥơ  */
#define PLPRCR_CSRC     BIT21_32    /*  å  */
                                    /*  ϥ⡼  */
#define PLPRCR_LPM      (BIT22_32 | BIT23_32)
#define PLPRCR_LPM10    BIT22_32


/*
 *  16. ꥳȥΥ쥸
 */

/*  ١쥸BRx  */
#define TADR_BR0    0x100
#define TADR_BR1    0x108
#define TADR_BR2    0x110
#define TADR_BR3    0x118
#define TADR_BR4    0x120
#define TADR_BR5    0x128
#define TADR_BR6    0x130
#define TADR_BR7    0x138

/*  ץ쥸ORx  */
#define TADR_OR0    0x104
#define TADR_OR1    0x10c
#define TADR_OR2    0x114
#define TADR_OR3    0x11c
#define TADR_OR4    0x124
#define TADR_OR5    0x12c
#define TADR_OR6    0x134
#define TADR_OR7    0x13c

#define TADR_MAMR   0x170   /*  ޥA⡼ɡ쥸  */
#define TADR_MBMR   0x174   /*  ޥB⡼ɡ쥸  */
#define TADR_MSTAT  0x178   /*  ꥹơ쥸MSTAT  */

#define TADR_MCR    0x168   /*  ꡦޥɡ쥸MCR  */
#define TADR_MDR    0x17c   /*  ꡦǡ쥸MDR  */
#define TADR_MAR    0x164   /*  ꡦɥ쥹쥸MAR  */
#define TADR_MPTPR  0x17a   /*  ޡץꥹ  */
                            /*  쥸MPTPR  */

/*
 *  19. ̿ץåCPϢΥ쥸
 */

/*  CPޥɥ쥸  */
#define CPCR        (VH *)(IMMR_BASE + 0x9c0)
#define CPCR_RST            BIT0_16  /*  ꥻåȡե饰  */
#define CPCR_FLG            BIT15_16 /*  ޥɡޥեե饰 */
#define CPCR_CH_NUM_SMC1    0x9      /*  SMC1Υֹͥ  */

/*  CPޥɤΥڥ  */
#define CPCR_INIT_RX_TX_PARAMETERS	0x0
#define CPCR_STOP_TX			0x4
#define CPCR_RESTART_TX			0x6



/*  ǥ奢롦ݡRAMƬɥ쥹  */
#define DUAL_PORT_RAM   (IMMR_BASE + 0x2000)


/*
 *  20. SDMAIDMAߥ졼
 *  SDMAꥢDMA
 *  IDMASDMA
 */

/*  SDMAե졼󡦥쥸  */
#define SDCR            (VW *)(IMMR_BASE + 0x30)
	/* RISCȥCPˤĴID */
	/* SDMA U ХĴͥ5̾ */
#define SDCR_RAID_RB5   0x1

/*
 *  21. ꥢ륤󥿡եSIϢΥ쥸
 */

/*  SI⡼ɡ쥸  */
#define SIMODE      (VW *)(IMMR_BASE + 0xae0)
#define SIMODE_SMC1 BIT16_32    /*  SMC1³  */
                                /*  0:NMSI⡼  */
                                /*  1:¿Ž⡼  */

                                /*  SMC1å  */
#define SIMODE_SMC1CS   (BIT17_32 | BIT18_32 | BIT19_32)    

/*  ܡ졼ȡͥ졼ե졼󡦥쥸  */
#define BRGC1       (VW *)(IMMR_BASE + 0x9f0)
#define BRGC1_RST   BIT14_32    /*  BRGꥻå  */
#define BRGC1_EN    BIT15_32    /*  BRGȥ֥͡  */
#define BRGC1_EXTC  (BIT16_32 | BIT17_32)   /*  å  */
#define BRGC1_ATB   BIT18_32    /*  ȥܡ  */
#define BRGC1_CD    0x1ffe      /*  åǥХ  */
#define BRGC1_DIV16 BIT31_32    /*  16ʬ  */


/*
 *  34. ѥI/OϢΥ쥸
 */

/*  ݡBԥ󡦥󡦥쥸  */
#define TADR_PBPAR  0xabc
#define PBPAR       (VW *)(IMMR_BASE + TADR_PBPAR)
#define PBPAR_DD24  BIT24_32    /*  PB24ԥѥڥե뵡ǽ  */
#define PBPAR_DD25  BIT25_32    /*  PB25ԥѥڥե뵡ǽ  */
#define PBPAR_DD27  BIT27_32    /*  PB27ԥѥڥե뵡ǽ  */

/*  ݡBǡǥ쥯󡦥쥸  */
#define TADR_PBDIR  0xab8
#define PBDIR       (VW *)(IMMR_BASE + TADR_PBDIR)
#define PBDIR_DR24  BIT24_32    /*  PB24ԥ󡧥ڥե뵡ǽ1  */
#define PBDIR_DR25  BIT25_32    /*  PB25ԥ󡧥ڥե뵡ǽ1  */
#define PBDIR_DR27  BIT27_32    /*  PB25ԥ󡧥ڥե뵡ǽ1  */

/*  ݡBץ󡦥ɥ쥤󡦥쥸  */
#define TADR_PBODR  0xac0
#define PBODR       (VW *)(IMMR_BASE + TADR_PBODR)
#define PBODR_OD24  BIT24_32    /*  PB24ԥ󡧥ץ󡦥ɥ쥤󡦥ɥ饤  */
#define PBODR_OD25  BIT25_32    /*  PB25ԥ󡧥ץ󡦥ɥ쥤󡦥ɥ饤  */
#define PBODR_OD27  BIT27_32    /*  PB25ԥ󡧥ץ󡦥ɥ쥤󡦥ɥ饤  */

/*  ݡBǡ쥸  */
#define TADR_PBDAT  0xac4
#define PBDAT_D27   BIT27_32


/*  åκݤ˥쥸˽񤭹  */
#define UNLOCK_KEY  0x55ccaa33

/*
 *  쥸ݸΥåȥå
 *
 *ꥢɥ饤Фȥޥɥ饤ФξѤ뤿ᡢ
 *ΥեƤ
 */

/*  SCCRå  */
    	/*  ͤUNLOCK_KEYʳǤɤ  */
#define lock_sccr()     mpc860_wrw_mem(SCCRK, 0)

/*  SCCRå  */
#define unlock_sccr()	mpc860_wrw_mem(SCCRK, UNLOCK_KEY)


#endif /* _MPC860_H_ */
/*  end of file  */
