/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *	ޥɥ饤СMPC860Tѡ
 *MPC860T¢μߥPIT
 *
 *ߥȥ¸ϤΥե˵Ҥ
 *ޥǥХΤ˰¸pit.h˵Ҥ
 *
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>

#ifndef _MACRO_ONLY
#include <pit.h>
#endif /* _MACRO_ONLY */

/*  ޳ߥϥɥΥ٥ֹ  */
#define	INHNO_TIMER	LEVEL_TO_INHNO(INTLVL_PIT)

/*  ޳ߤIPM  */
#define	IPM_PIT		LEVEL_TO_IPM(INTLVL_PIT)

/*  ޳ߤεĥӥå  */
#define	ENABLE_PIT	LEVEL_TO_ENABLE_BIT(INTLVL_PIT)


#ifndef _MACRO_ONLY

/*
 *  ޳׵Υꥢ
 */
#define hw_timer_int_clear	pit_int_clear


/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
	/*
	 *  ޥǥХΤν
	 */
	pit_initialize();

	/*
	 *  ƥ।󥿡ե˥åSIUIPM
	 */
	mpc860_orh_mem(SIMASK, ENABLE_PIT);

	/*
	 *  ͥΥǡ
	 */
	define_ipm(INHNO_TIMER, IPM_PIT);	/* IPMꡡ*/

	
	pit_int_clear();	/*  ׵򥯥ꥢ  */
	pit_start();		/*  ޥ    	*/
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
#define hw_timer_terminate		pit_terminate

/*
 *  ޤθͤɽФ
 *ޤưŪߤͤɤ߽Ф
 */
#define hw_timer_get_current		pit_get_current

/*
 *  ޳׵Υå
 */
#define hw_timer_fetch_interrupt	pit_fetch_interrupt

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
/*  end of file  */
