/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <sys_rename.h>

/*
 *  ߥȥ顦ܡɰ¸Υ󥯥롼ɥեɤ߹
 */
#include <pic_icu.h>	/* ߥȥطξ<CPU>Ϥ */
#include <vr5500.h>	/* NOP_FOR_CP0_HAZARDξcpu_support.SϤ */

/*
 *  vgxet_tim 򥵥ݡȤ뤫ɤ
 */
#define	SUPPORT_VXGET_TIM

/*
 *  ꥢݡȿ
 */
#ifndef GDB_STUB
#define TNUM_SIOP	2u	/* ݡȤ륷ꥢݡȤο */
#define TNUM_PORT	2u	/* ݡȤ륷ꥢI/OݡȤο */
#else  /* GDB_STUB */
#define TNUM_SIOP	1u	/* ݡȤ륷ꥢݡȤο */
#define TNUM_PORT	1u	/* ݡȤ륷ꥢI/OݡȤο */
				/* GDB_STUB ѤȤϡSCC1 GDB_STUB 
				   Ѥ뤿ˡSCC0ΤߤѤǤʤ */
#endif /* GDB_STUB */


/*
 *  ƥॿ˴ؤ
 */
#define	LOGTASK_PORTID	1u	/* ƥϤ륷ꥢݡֹ */

/*
 *  ԤΤ
 */
#define	SIL_DLY_TIM1	2865
#define	SIL_DLY_TIM2	398

/*
 *  ߥޥν (MIPS3Τ⥿åȥƥ¸ʤΤǡ)
 */

/*  MIPS3δط */
/*  ¼ŪʳϡߥȥǹԤᡢMIPS3˴ؤƤ
    ǽʬĤ롣*/
/*  RTE-VR5500-CBǤ2ܤγ³Ƥ롣 */
#define INIT_CORE_IPM	( Cause_Int1 | Cause_Int0 )

/*  ߥȥط  */
/*  (ˤơޣΤ߳ߵġ */
#define INIT_INT0M	TIMER0
#define INIT_INT1M	0u

#ifndef _MACRO_ONLY

/*
 *  åȥƥ¸ν
 */
extern void	sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻ȤROM˥ƽФǼ¸뤳Ȥꤷ
 *  Ƥ롥
 */
extern void	sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼ROM˥ƽФǼ¸뤳
 *  ȤꤷƤ롥
 */

extern void	sys_putc(char c) throw();

#endif /* _MACRO_ONLY */

/*============================================================================*/
/* ʲϡ̥ɥȤ̵ȼ */

/*
 *  ơ쥸ν
 */
#define INIT_SR		(SR_BEV | INIT_CORE_IPM | SR_DE)
	/*
	 *  BEV = 1㳰٥kseg0Ȥ
	 *  IM = 0CPUå (߶ػ)
	 *  DE = 1 : åѥƥ顼ˤ㳰ȯζػ
	 */

/*
 *  ե쥸ѥޥ
 */
#define INIT_CONFIG_MASK	0x0

/*
 *  ꥢ륳ȥΥܡ졼Ȥ (ʬǡ[bps]ǻ)
 */
#define DEVIDE_RATIO	9600u	/*  9600bps  */

#endif /* _SYS_CONFIG_H_ */
