/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#include "jsp_kernel.h"
#include <hw_serial.h>		/* ǥХåꥢ륳ȥط */

/*  ߥȥѤߥޥεơ֥  */
ICU_IPM icu_intmask_table[ TMAX_ALL_INTNO ];

/*
 *  åȥƥ¸ 롼
 */
void sys_initialize() {

	ICU_IPM icu_ipm0 = {INIT_MSYSINT1, INIT_MSYSINT2};

	/*
	 *  ߥȥγߥޥν
	 */
	icu_set_ipm( &icu_ipm0 );

#ifndef GDB_STUB

	/*
	 *  DSIUؤΥå볫
	 */
	vr4131_orh( (VP) CMUCLKMSK, (MSKDSIU | MSKSSIU | MSKSIU) );

	/*
	 *  Хʡɽѥꥢ륳ȥ(DSIU)ν
	 */
	sio_init();

#endif	/*  GDB_STUB  */

}

/*
 *  åȥƥνλ롼
 */
void sys_exit(void) {

#ifndef GDB_STUB
	while (1);
#else	/*  GDB_STUB  */
	vr4131_exit();
#endif	/*  GDB_STUB  */

}

/*
 *  GDB STUB / ľܸƽФ 󥽡ƽФ롼
 */

/*
 *  gdb stub ˤ륳󥽡
 */
/* a0($4) = 0xfe00, a1($5) = Ϥ饯 ơ
   SYSCALL 㳰ȯ롣 */

/* δؿƤӽФˤϡơ쥸EXLӥå = 0 ǸƤӽФȡ
   ʤߡͥǤϡХʡɽꥢϻ˸ƽФԤäƤ롣*/
void stub_putc(int c) {

	Asm("	move	$5, %0;		\
	     	li	$4, 0xfe00;	\
		syscall;		\
		nop"
		:: "r"(c)
		: "$4","$5" );
}

#ifdef GDB_STUB			/* GDB_STUB ξ */
#define vr4131_putc(c)	stub_putc( c )
#else /* GDB_STUB */		/* ¾ */
#define	vr4131_putc(c)	sio_snd_chr_pol( c )
#endif /* GDB_STUB */

/*
 *   ƥʸλ
 */
void sys_putc(char c) {

	if (c == '\n') {
		vr4131_putc('\r');
	}
	vr4131_putc(c);
}

/*============================================================================*/
