/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.7 2003/12/11 00:58:01 honda Exp $
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

/*
 * CPU¸ޥ⥸塼MicroBlazeѡ
 */ 
#include <s_services.h>
#include <microblaze.h>

/*
 * ޳ߥϥɥγֹ
 */
#define INHNO_TIMER TIMINTLVL

#ifndef _MACRO_ONLY

/*
 * ͤɽη
 */
typedef UW CLOCK;

/*                                                                             
 *  ͤɽȥߥáñ̤ȤѴ                               
 *  TIMER_CLOCK ϥåȥܡ                                     
 */
#define TO_CLOCK(nume, deno)  (TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)      ((clock) * 1000 / TIMER_CLOCK)

/*
 *  Ǥ祿޼ñ̤ɽ
 */
#define MAX_CLOCK ((CLOCK) 0xffffffff)

/*
 *  ǽɾѥƥФݤν֤θѤ͡ñ̤ɽ
 */
#define GET_TOLERANCE	100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)


/*
 * ޤεư
 *
 * ޤŪʥ޳ߤȯ
 */ 
Inline void
hw_timer_initialize(void)
{
  
  CLOCK cyc = TO_CLOCK(TIC_NUME, TIC_DENO);

  sil_wrw_mem((VP)TIMER_TCSR0,TIMER_RESET); /* ꥻå */
  
  assert(cyc <= MAX_CLOCK);	                /* ޾ͤΥå */
  sil_wrw_mem((VP)TIMER_TCCR0, cyc);        /* 󥿡å */
  
  /*
   * ޡ0֥͡롤ȥɡ󥫥ȡߵġ
   */
  sil_wrw_mem((VP)TIMER_TCSR0,TIMER_ENABLE | TIMER_RELOAD | TIMER_DOWN_COUNT
                                | TIMER_ENABLE_INTR);

  /*
   *  INTCߵ
   */
  intc_enable_interrupt((1 << (TIMINTLVL - 1)));
}



/*
 *   ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
  sil_wrw_mem((VP)TIMER_TCSR0,sil_rew_mem((VP)TIMER_TCSR0));
  /*
   * ٥ߤΤᡤװ򲼤ACK
   */
  intc_ack_interrupt(1 << (TIMINTLVL - 1));
}



/*
 *   ޤζػ߽
 */
Inline void
hw_timer_terminate()
{
  int dummy;
  
  sil_wrw_mem((VP)TIMER_TCSR0, ~TIMER_ENABLE); /*          */
  sil_wrw_mem((VP)TIMER_TCSR0, sil_rew_mem((VP)TIMER_TCSR0));  /* ׵Υꥢ */
  
  /*
   * Ǥ˳ߤäƤ礬Τǳ׵򥯥ꥢ
   */
  dummy = 1 << (TIMINTLVL - 1);
  intc_ack_interrupt(dummy);
  intc_disable_interrupt(dummy);  /* INTCμդػ */
}



/*
 *   ޤθͤɤ߽Ф
 *
 *   ߶ػ߶ǸƤӽФ
 */
Inline CLOCK
hw_timer_get_current(void)
{
  return(TO_CLOCK(TIC_NUME, TIC_DENO) - sil_rew_mem((VP)TIMER_TCR0));
}



/*
 *   ߤȯƤ뤫Ƚ
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
  return(sil_rew_mem((VP)TIMER_TCSR0) & TIMER_INTERRUPT);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
