/* 
 *
 *  TOPPERS/JSP Kernel
 *     Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 * 嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 * ˤäƸɽƤ GNU General Public License  Version 2 ˵
 * ҤƤ˸¤ꡤܥեȥܥեȥ
 * ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 * ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 * (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *     ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *     ˴ޤޤƤ뤳ȡ
 * (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *     ѤǤǺۤˤϡۤȼɥȡ
 *     ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *     ̵ݾڵǺܤ뤳ȡ
 * (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *     ѤǤʤǺۤˤϡΤ줫ξ
 *     ȡ
 *   (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *       ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *   (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *       𤹤뤳ȡ
 * (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *     ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 * ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 * TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 * ޤơʤݾڤԤʤޤܥեȥѤˤľ
 * ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: cpu_support.S,v 1.15 2007/04/19 06:38:27 honda Exp $
 */

#define _MACRO_ONLY
        
/*
 *  ץꥱȶ̤Υ󥯥롼ɥե
 */
#include <kernel.h>
                
/*
 *  åȰ¸
 */
#include <t_config.h>

#include "jsp_kernel.h"
#include "offset.h"
#include <microblaze_asm.inc>
#include <microblaze.h>


/*
 * INTC߷פˤĤơ
 *
 *  ¸쥸
 *  R3-R4   Return Valus        (Volatile)
 *  R5-R10  Passing parameters  (Volatile)
 *  R11-R12 Temporaries         (Volatile)
 *  R14     Return address for interrupt
 *  R15     Return address for Sub-routine
 *  R16     Return address for Trap(Debugger)
 *  R17     Return address for Exeptions
 * ?R18     Reserved for Assember    
 */

#define STACK_TOP (STACKTOP - 0x4) 

#define INTC_ISR (INTC_BASE + INTC_INT_STATUS_REG)
#define INTC_IPR (INTC_BASE + INTC_INT_PENDING_REG)
#define INTC_IER (INTC_BASE + INTC_INT_ENABLE_REG)
#define INTC_IAR (INTC_BASE + INTC_INT_ACK_REG)
#define INTC_SIE (INTC_BASE + INTC_SET_INT_ENABLE)
#define INTC_CIE (INTC_BASE + INTC_CLEAR_INT_ENABLE)
#define INTC_IVR (INTC_BASE + INTC_INT_VECTOR_REG)
#define INTC_MER (INTC_BASE + INTC_MASTER_ENABLE_REG)


/*
 *  㳰ȥ
 *  Not Support!
 */
	.text
	.globl exception_entry
	.align 2
exception_entry:
	nop
	



	.text
	.globl interrupt_entry
	.align 2
interrupt_entry:
/*
 * åݥ󥿤ڤؤɬ
 */
	addik r1,r1,-64
	swi r3,  r1, 60
	swi r4,  r1, 56
	swi r5,  r1, 52
	swi r6,  r1, 48
	swi r7,  r1, 44
	swi r8,  r1, 40
	swi r9,  r1, 36
	swi r10, r1, 32
	swi r11, r1, 28
	swi r12, r1, 24
	swi r14, r1, 20
	swi r15, r1, 16
	swi r16, r1, 12
	swi r17, r1, 8
	swi r18, r1, 4
	mfs r3,  rmsr     /* msr¸ */
	swi r3,  r1, 0

	lwi   r5,  r13, interrupt_count
	bgti  r5,  nest_int      /* ͥȲ1ʾʤ饹åڤؤʤ */
	
	/*
	 * åݥڤؤ
	 */
	la    r4,  r0, STACK_TOP   /* ΩΥåɤ߹ */
	sw    r1,  r0, r4          /* å¸             */
	Mov   r1,  r4              /* åݥڤؤ         */
nest_int:
	/* 
     * ߥͥȲΥ󥯥
	 */
	addi  r5,  r5,  1 
	swi   r5,  r13, interrupt_count

	lwi   r3,  r0, INTC_IVR    /* ٥ɤ߹                 */
	add   r3,  r3, r3          /* ٥4                      */
	add   r3,  r3, r3	        
	lwi   r5,  r3, int_handler_table /* ϥɥ饢ɥ쥹ɤ߹ */
	lwi   r6,  r3, int_bit_table     /* ޥӥåȤɤ߹     */
	swi   r6,  r0, INTC_CIE          /* ȯߤޥ     */
	ori   r4,  r0, 0x02 | MSR_CACHE_SETTING /* r4 = 0x02           */
	Push  r6                         /* ޥӥåȤ򥹥å   */

	mts   rmsr,r4                    /* ߵ(MSR(IE)򥻥å)*/

	brald r15, r5             /* ϥɥƤӽФ */
	 nop

    la    r4, r0, MSR_CACHE_SETTING  
	mts   rmsr,r4                    /* ߶ػ                 */

//    ori   r4,  r0, 0x03       /* r4 = 0x03                         */
//    swi   r4,  r0, INTC_MER   /* INTC_MER = 0x0 INTC       */

	Pop   r6                         /* ޥӥåȤμФ     */
//	swi   r6,  r0, INTC_IAR          /* ACK                        */        
	swi   r6,  r0, INTC_SIE          /* ȯߤε           */

	/*
	 *  ߥͥȲΥǥ
     */
	lwi   r5,  r13, interrupt_count
	addi  r5,  r5,  -1 
	swi   r5,  r13, interrupt_count
	
	bgti  r5,  ret_to_task_int      /* ͥȲ1ʾʤ */

	lw    r1,  r0, r1	            /* åݥ󥿤᤹    */  
	lwi   r4,  r13, reqflg          /* reqflg Υå         */
	beqi  r4,  ret_to_task_int      /* FALSE ʤ    */
	bri   ret_int                   /* TRUE ʤ ret_int       */
ret_to_task_int:
	lwi  r3,  r1, 0
	mts  rmsr,r3
	lwi  r18, r1, 4
	lwi  r17, r1, 8
	lwi  r16, r1, 12
	lwi  r15, r1, 16
	lwi  r14, r1, 20
	lwi  r12, r1, 24
	lwi  r11, r1, 28
	lwi  r10, r1, 32
	lwi  r9,  r1, 36
	lwi  r8,  r1, 40
	lwi  r7,  r1, 44
	lwi  r6,  r1, 48
	lwi  r5,  r1, 52
	lwi  r4,  r1, 56
	lwi  r3,  r1, 60
	rtid r14,0 
	addik r1,r1,64



	/*
	 * ̤ϿγߤȯȸƤӽФ
	 * Not Yet!
	 */
	.globl no_reg_interrupt
	.align 2
no_reg_interrupt:
	nop


	/*
	 * ǥѥå
	 * 
	 * dispatch ϡinterrupt_count = 0 
     * MSR IE=0 γ߶ػ߾֤ǸƤӽФʤФʤʤ
	 * exit_and_dispatch Ʊͤˡinterrupt_count = 0 ߶ػ߾֤
     * ƤӽФΤ§Ǥ뤬ͥ뵯ưб뤿ᡤ
     * interrupt_count = 1 ǸƤӽФˤбƤ롥
	 *    
	 */
	
	.globl dispatch
	.align  2
dispatch:
	addi  r1,  r1,  -64  /* å쥸ʳ¸ */
	swi   r15, r1,  60
	mfs   r3,  rmsr      /* msr¸(å¸) */
	swi   r3,  r1,  56                
	swi   r18, r1,  52   /* ɬפ? */
	swi   r19, r1,  48
	swi   r20, r1,  44
	swi   r21, r1,  40
	swi   r22, r1,  36
	swi   r23, r1,  32
	swi   r24, r1,  28
	swi   r25, r1,  24
	swi   r26, r1,  20
	swi   r27, r1,  16
	swi   r28, r1,  12
	swi   r29, r1,  8
	swi   r30, r1,  4
	swi   r31, r1,  0
	lwi   r4 , r13, runtsk     /* r4 <- runtsk */
	swi   r1 , r4,  TCB_sp 	   /* åTCB¸ */	
	la    r5 , r0,  dispatch_r /* ¹ԺƳϤ¸ */
	swi   r5 , r4,  TCB_pc     /* ¹ԺƳϤTCB¸   */
	bri   dispatcher

dispatch_r:
	lwi  r31,  r1, 0      /* 쥸 */
	lwi  r30,  r1, 4
	lwi  r29,  r1, 8
	lwi  r28,  r1, 12
	lwi  r27,  r1, 16
	lwi  r26,  r1, 20
	lwi  r25,  r1, 24
	lwi  r24,  r1, 28
	lwi  r23,  r1, 32
	lwi  r22,  r1, 36
	lwi  r21,  r1, 40
	lwi  r20,  r1, 44
	lwi  r19,  r1, 48
	lwi  r18,  r1, 52
    lwi  r3,   r1, 56   /* MSR᤹(å᤹) */
    mts  rmsr,r3            
	addi r1,   r1, 60   /* åݥ󥿤᤹ */
	/*
	 *  㳰롼εư
	 *  dispatch_r  dispatcher ƤӽФ뤿ᡤ
	 *  tcb Υɥ쥹 r4 äƤ
     *  Not Yet!
	 */
	lwi  r5,  r4,  TCB_enatex  /* r5 <- enatex                 */
	andi r6,  r5,  TCB_enatex_mask  
	beqi r6,  dispatch_r_1     /* enatex  FALSE ʤ꥿ */
	lwi  r7,  r4,  TCB_texptn  /* r5 <- texptn                 */
	beqi r7,  dispatch_r_1     /* texptn  0 Ǥʤ       */
	brlid r15  call_texrtn     /* 㳰롼θƤӽФ */	
	 nop
dispatch_r_1:
	Pop     r15
	rtsd	r15,8 
	 nop



	.globl exit_and_dispatch
exit_and_dispatch:
	/* interrupt_count 򥯥ꥢ */
	swi   r0,  r13, interrupt_count 
dispatcher:
	/*
	 * ϳ߶ػߤ뤳
	 */
	lwi  r4,  r13, schedtsk  /* r4 <- schedtsk              */
	swi  r4,  r13, runtsk    /* schedtsk  runtsk        */        
	beqi r4,  dispatcher_1   /* schedtsk 뤫           */
	lwi  r1,  r4,  TCB_sp    /* TCB饿å */
	lwi  r5,  r4,  TCB_pc    /* TCB¹ԺƳϤ   */
	bra  r5	  
dispatcher_1:
	/*
	 * ǳߥ⡼ɤڤؤΤϡȯ߽
     * ˤɤΥåȤȤβȡߥϥɥ
	 * ΥǥѥåɻߤȤ2Ĥΰ̣롥
	 */
	la   r1,  r0,  STACKTOP         /* ߥåѹ             */
	la   r6,  r0,  1                /* interrupt_count 1            */
	swi  r6,  r13, interrupt_count
	la   r5,  r0, 0x02 | MSR_CACHE_SETTING /* IE = '1'               */
	la   r4,  r0, MSR_CACHE_SETTING        /* IE = '0'               */        
dispatcher_2:
	mts   rmsr, r5   /* ߵ(MSR(IE)򥻥å)      */
	nop
	nop
	mts   rmsr, r4                  /* ߶ػ(MSR(IE)򥯥ꥢ)      */
	lwi   r6,  r13,  reqflg         /* r6 <- reqflg                     */
	beqi  r6,  dispatcher_2         /* reqflg  FALSE ʤ             */
	swi   r0,  r13, interrupt_count /* interrupt_count 򥯥ꥢ         */
	swi   r0,  r13,  reqflg         /* reqflg  FALSE                */	
	bri   dispatcher

	/*
	 *  ߥϥɥ/CPU㳰ϥɥи
	 * 
	 * 褬 reqflg åȤƤΤߤˤ롥
	 * interrupt_count = 0߶ػ߾֡å쥸¸
	 * ֤ǸƤӽФȡ
	 */
	.align 2
	.globl ret_int
	.globl ret_exc
ret_exc:
ret_int:
	swi  r0,  r13,  reqflg   /* reqflg  FALSE  */
	lwi  r4,  r13,  runtsk   /* r4 <- runtsk        */
	lwi  r6,  r13,  enadsp   /* r6 <- enadsp        */
	beqi r6,  ret_int_1      /* enadsp  FALSE ʤ ret_int_1  */
	lwi  r5,  r13,  schedtsk /* r5 <- schedtsk                    */
	sub  r6,  r5,   r4       /* runtsk  schedtsk Ʊʤ     */
	beqi r6,  ret_int_1      /* ret_int_1                       */
	addi  r1,  r1,  -52      /* ĤΥ쥸¸          */
	swi   r19, r1,  48
	swi   r20, r1,  44
	swi   r21, r1,  40
	swi   r22, r1,  36
	swi   r23, r1,  32
	swi   r24, r1,  28
	swi   r25, r1,  24
	swi   r26, r1,  20
	swi   r27, r1,  16
	swi   r28, r1,  12
	swi   r29, r1,  8
	swi   r30, r1,  4
	swi   r31, r1,  0	
	swi   r1 , r4,  TCB_sp 	   /* åTCB¸ */	
	la    r6 , r0,  ret_int_r  /* ¹ԺƳϤ¸ */
	swi   r6 , r4,  TCB_pc     /* ¹ԺƳϤTCB¸   */
	bri   dispatcher

ret_int_r:	
	lwi  r31,  r1,  0      /* 쥸 */
	lwi  r30,  r1,  4
	lwi  r29,  r1,  8
	lwi  r28,  r1,  12
	lwi  r27,  r1,  16
	lwi  r26,  r1,  20
	lwi  r25,  r1,  24
	lwi  r24,  r1,  28
	lwi  r23,  r1,  32
	lwi  r22,  r1,  36
	lwi  r21,  r1,  40
	lwi  r20,  r1,  44
	lwi  r19,  r1,  48
	addi r1,   r1,  52
	lwi  r3,   r1,   0    /* MSR ᤹ʥå᤹*/
	mts  rmsr, r3                
ret_int_1:
	/*
	 * 㳰롼εư
	 * ret_int_r  dispatcher ƤӽФ뤿ᡤ
	 * tcb Υɥ쥹 r4 äƤ
	 */
	lwi  r5,  r4,  TCB_enatex  /* r5 <- enatex                 */
	andi r6,  r5,  TCB_enatex_mask  
	beqi r6,  ret_int_2        /* enatex  FALSE ʤ꥿ */
	lwi  r7,  r4,  TCB_texptn  /* r5 <- texptn                 */
	beqi r7,  ret_int_2        /* texptn  0 Ǥʤ       */
	brlid r15  call_texrtn     /* 㳰롼θƤӽФ */	
	 nop
ret_int_2:
	lwi  r3,  r1, 0    /* MSR ᤹ʳIE=0ǳ߶ػߤˤʤ*/
	mts  rmsr,r3
	lwi  r18, r1, 4
	lwi  r17, r1, 8
	lwi  r16, r1, 12
	lwi  r15, r1, 16
	lwi  r14, r1, 20
	lwi  r12, r1, 24
	lwi  r11, r1, 28
	lwi  r10, r1, 32
	lwi  r9,  r1, 36
	lwi  r8,  r1, 40
	lwi  r7,  r1, 44
	lwi  r6,  r1, 48
	lwi  r5,  r1, 52
	lwi  r4,  r1, 56
	lwi  r3,  r1, 60
	rtid r14,0 
	 addik r1,r1,64	



	/*
	 * ư
     *   
     *  åμ
     *  Microblaze Processor Reference Guide 5253
     *  ؿƽФΤϡr5r10 ˳Ǽ롥
     *  Ʊ˸ƽФϥåե졼˰γǼݤɬ
     *  롥ˤξˤϥ󥯥쥸(R15)ʬΰ褬ɬפȤʤ롥
     *  ƽФϹ¾δؿƤӽФ r5r10 򤳤ΰ¸
     * 롥
     *  Low Address
     *             --------------------
     *  new_sp -> | Link Register(R15) |
     *             --------------------
     *            |   Arg1Ѥΰ     |
     *             --------------------
     *            |   Arg2Ѥΰ     |
     *             --------------------        
     *            |      ....          |
     *             --------------------
     *  High Address
	 */

	.text
	.globl activate_r
	.align 2
activate_r:
	ori   r4,  r0, 0x02 | MSR_CACHE_SETTING  /* msrν        */
	mts   rmsr,r4              /* ߵ(MSR(IE)򥻥å)      */
    lw    r11, r1, r0          /* μ¹                 */
    lwi   r5,  r1,  4          /* exinf                    */
	la    r15, r0,  ext_tsk -8 /*                */
	bra   r11                  /* μ¹Գ                 */


        
    /*
     * Ԥ
     */
     .globl _sil_dly_nse
_sil_dly_nse:
     addi   r5, r5, -SIL_DLY_TIM1
     bgti   r5, _sil_dly_nse_1
     rtsd   r15, 8
      nop  
_sil_dly_nse_1:
     addi   r5, r5, -SIL_DLY_TIM2
     bgti   r5, _sil_dly_nse_1
     rtsd   r15, 8
      nop          
