/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2006 by Monami Software Limited Partnership, JAPAN	
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.11 2007/05/30 03:56:47 honda Exp $
 */

//#include <sys_config.h>

/*
 *	ץå¸⥸塼M32Rѡ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

#include <cpu_rename.h>

#include "m32r.h"

/*
 *  chg_ipm/get_ipm 򥵥ݡȤ뤫ɤ
 */
/*#define	SUPPORT_CHG_IPM*/

/*
 *  TCB Ϣ
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */

/*
 *  TCB ΥեɤΥӥå
 */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */

#ifndef _MACRO_ONLY
/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	unsigned long sp;		/* åݥ */
	FP	pc;					/* ץ५ */
} CTXB;

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβ
 *
 *  CPUåCPUĳ׵/ػߤбդ롣PSWIEӥå
 *  롣
 */

#define t_lock_cpu		lock_cpu
#define i_lock_cpu		lock_cpu
#define t_unlock_cpu	unlock_cpu
#define i_unlock_cpu	unlock_cpu
#define ena_int			lock_cpu
#define dis_int			unlock_cpu

Inline void
lock_cpu()
{
	__asm("mvfc r0, psw        \n"
	      "and3 r0, r0, 0xffbf \n"
	      "mvtc r0, psw " : : : "r0");
}

Inline void
unlock_cpu()
{
	__asm("mvfc r0, psw       \n"
	      "or3  r0, r0, 0x40  \n"
	      "mvtc r0, psw " : : : "r0");
}

/*
 *  sense_context
 *  
 *  桼åȤäƤʤ饿ƥ
 */

Inline BOOL
sense_context(void)
{
	int psw;
	__asm("mvfc	%0, psw" : "=r"(psw));
	return (psw & 0x80) != 0 ? FALSE : TRUE;
}

/*
 *  sense_lock
 *  
 *  ߶ػߤʤCPUå
 */
Inline BOOL
sense_lock(void)
{
	int psw;
	__asm("mvfc	%0, psw" : "=r"(psw));
	return (psw & 0x40) != 0 ? FALSE : TRUE;
}

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */

extern FP InterruptHandlerEntry[NUM_INTERRUPT];
extern FP ExceptionHandlerEntry[NUM_EXCEPTION];

/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{
	InterruptHandlerEntry[inhno-1] = inthdr;
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr ꤹ롥
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
	ExceptionHandlerEntry[excno-1] = exchdr;
}

/*
 *  ߥϥɥ顿CPU㳰ϥɥν
 */


/*
 *  ߥϥɥνޥ
 *
 *  reqflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡǥ
 *  ѥåʤ
 */
#define INT_ENTRY(hdr) hdr
#define INTHDR_ENTRY(entry)	extern void entry();

/*
 *  CPU㳰ϥɥνޥ
 *
 *  CPU㳰ϥɥϡ󥿥ƥȤǼ¹Ԥ롥ΤᡤCPU
 *  ϥɥƤӽФ˳ߥ⡼ɤ˰ܹԤ꥿󤷤Ƥ
 *  Υ⡼ɤ᤹Υ⡼ɤ᤹ˡߥ⡼ɤ˰ܹԤ
 *   SR ߥå¸롥CPU㳰ƥȤ
 *  ȯreqflg  TRUE ˤʤäˡret_exc ʬ롥
 *  reqflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡǥ
 *  ѥåʤ
 */
#define EXC_ENTRY(hdr) hdr
#define EXCHDR_ENTRY(entry)	extern void entry();

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥ
 *
 *  󥿥ƥȤξTRUE֤p_excinf㳰ϥɥ
 *  ӽФݤΥåݥ󥿤ǼƤcpu_support.SˤΤǡ
 *  㳰ȯpswƥȤȽǤ롥
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return (((unsigned int*)p_excinf)[1] & 0x8000) == 0;
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return (((unsigned int*)p_excinf)[1] & 0x4000) == 0;
}

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

/*
 * ߽γͥ
 */
extern ER get_ipr(IPR *);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
