/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Ryosuke Takeuchi
 *              Platform Development Center RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_context.h,v 1.3 2005/11/24 12:41:23 honda Exp $
 */


/*
 *	ƥ롼M32Cѡ
 *
 *  Υե cpu_config.h ʬΥƤΤϡΥե TCB
 *  줿ɤɬפΤФơcpu_config.h ˤ TCB 
 *  ɤɬפޤǤ뤿Ǥ롥
 */

#ifndef _CPU_CONTEXT_H_
#define _CPU_CONTEXT_H_

#include "task.h"

#ifndef _MACRO_ONLY

/*
 *  ƥȤν
 *
 *  ٻ߾֤˰ܹԤʥνλˤ˸
 *  Ф롥ŪˤϡƥȤ򥿥ưǤ֤
 *  ꤹcreate_context  activate_context ǹԤФ褤
 */
Inline void
create_context(TCB *tcb)
{
}

/*
 *  εư
 *
 *  ٻ߾֤¹ԤǤ֤˰ܹԤ˸ƤФ롥
 */
extern void	activate_r(void);

Inline void
activate_context(TCB *tcb)
{
	VW *sp;

	/*  åݥ󥿽ͤ  */
	sp = (VW *)(((VB *) tcb->tinib->stk) + tcb->tinib->stksz);

	/*  ưɬפʥǡ(,,ư)򥹥åѤ  */
	*--sp = (VW)(tcb->tinib->exinf);
	*--sp = (VW)ext_tsk;
	*--sp = (VW)(tcb->tinib->task);

	tcb->tskctxb.pc = activate_r;	/*  cpu_support.a30  */
	tcb->tskctxb.sp = sp;
}

/*
 *  calltex Ѥʤ
 */
#define OMIT_CALLTEX

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONTEXT_H_ */
