/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Ryosuke Takeuchi
 *              Platform Development Center RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭ԤϡFree Software Foundation ˤäƸɽƤ 
 *  GNU General Public License  Version 2 ˵ҤƤ狼
 *  (1)(4)ξ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥѲǽʥХʥꥳɡʥ֥륪
 *      ȥե饤֥ʤɡˤηѤˤϡ
 *      ȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭ɽ
 *      Ѿ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥԲǽʥХʥꥳɤηޤϵ
 *      ߹ѤˤϡΤ줫ξȡ
 *    (a) ѤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) Ѥη֤̤ˡˤäơ嵭Ԥ𤹤
 *        ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭Ԥդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥϡ
 *  ܥեȥ˴ؤơŬѲǽޤơʤݾڤԤ
 *  ʤޤܥեȥѤˤľŪޤϴŪ
 *  ʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: serial_mini.c,v 1.4 2007/01/05 02:33:59 honda Exp $
 */

/*
 *	ꥢ륤󥿥եɥ饤
 */

#include <t_services.h>
#include <serial.h>
#include <hw_serial.h>
#include "kernel_id.h"

/*
 *  ꥢݡȴ֥å
 */

#define	SERIAL_BUFSZ	9	/* ꥢ륤󥿥եѥХåեΥ */

typedef struct serial_queue_block {
	BOOL openflag;				/* ץѤߥե饰 */
	UH   base;					/* hardware port base address */
	ID   rsemid;				/* receive semaphore id */
	ID   ssemid;				/* send semaphore id */
	char head;					/* queue head */
	char tail;					/* queue tail */
	char size;					/* Хåե */
	char buffer[SERIAL_BUFSZ];	/* Хåեꥢ */
} SQUE;

static SQUE	in_queue[TNUM_SIOP] ={
	FALSE, TADR_SFR_UART0_BASE, SERIAL_RCV_SEM1, SERIAL_SND_SEM1, 0, 0, SERIAL_BUFSZ, "",
	FALSE, TADR_SFR_UART1_BASE, SERIAL_RCV_SEM2, SERIAL_SND_SEM2, 0, 0, SERIAL_BUFSZ, ""
};

/*
 *  ꥢݡȴ֥åȽ
 */

#define get_sque(portid)	(&(in_queue[portid-1]))

/*
 *  SFR UARTν
 */
Inline void
SFR_uart_initialize(ID portid)
{
	SQUE  *q;
	VB *ip = (VB*)(TADR_SFR_INT_BASE+TADR_SFR_S0RIC_OFFSET);

	q = get_sque(portid);
	  			/* ⡼ɥ쥸ν */
	sil_wrb_mem((VP)(q->base+TADR_SFR_UMR_OFFSET), MR_DEF);
				/* 쥸ν */
	sil_wrb_mem((VP)(q->base+TADR_SFR_UC0_OFFSET), C0_DEF);
				/* ž®٥쥸ν */
	sil_wrb_mem((VP)(q->base+TADR_SFR_UBRG_OFFSET), BRG1_DEF);
				/* ߥ٥ */
	set_ic_ilvl((VP)(ip + ((INT)portid-1)*2), RB_LEVEL);
	sil_wrb_mem((VP)(q->base+TADR_SFR_UC1_OFFSET), C1R_DEF);
	sil_reb_mem((VP)(q->base+TADR_SFR_URB_OFFSET));		/* ߡǡ */
	sil_reb_mem((VP)(q->base+TADR_SFR_URB_OFFSET));		/* ߡǡ */
	q->openflag = TRUE;
}

/*
 *  SQUEμХåե饵Ф
 */
Inline int
queue_size(SQUE *q)
{
	int size = q->head - q->tail;
	if(size < 0)
		size += q->size;
	return size;
}

/*
 *  ꥢ륤󥿥եɥ饤Фεư
 */
void
serial_initialize(VP_INT exinf)
{
	SFR_uart_initialize(LOGTASK_PORTID);
}

/*
 *  ꥢݡȤΥץ
 */
ER
serial_opn_por(ID portid)
{
	SQUE  *q;
	VB    *ip=(VB*)(TADR_SFR_INT_BASE+TADR_SFR_S0RIC_OFFSET);
	ER	ercd;

	if (!(1 <= portid && portid <= TNUM_SIOP)) {
		return(E_ID);		/* ݡֹΥå */
	}
	q = get_sque(portid);

	_syscall(loc_cpu());
	if (q->openflag) {		/* ץѤߤΥå */
		ercd = E_OBJ;
	}
	else {
		SFR_uart_initialize(portid);
		ercd = E_OK;
	}
	_syscall(unl_cpu());
	return(ercd);
}

/*
 *  ꥢݡȤΥ
 */
ER
serial_cls_por(ID portid)
{
	SQUE  *q;
	VB    *ip=(VB*)(TADR_SFR_INT_BASE+TADR_SFR_S0RIC_OFFSET);
	ER	ercd;

	if (!(1 <= portid && portid <= TNUM_SIOP)) {
		return(E_ID);		/* ݡֹΥå */
	}
	q = get_sque(portid);

	_syscall(loc_cpu());
	if (!(q->openflag)) {	/* ץѤߤΥå */
		ercd = E_OBJ;
	}
	else {
		set_ic_ilvl((VP)(ip + ((INT)portid-1)*2), 0);
		sil_wrb_mem((VP)(q->base+TADR_SFR_UC1_OFFSET), C1S_DEF);
		q->openflag = FALSE;
		ercd = E_OK;
	}
	_syscall(unl_cpu());
	return(ercd);
}

/*
 *  ꥢݡȤؤ
 */

ER_UINT
serial_wri_dat(ID portid, char *buf, UINT len)
{
	SQUE	*q;
	unsigned int	i;
	unsigned char   c;

	if (!(1 <= portid && portid <= TNUM_SIOP)) {
		return(E_ID);		/* ݡֹΥå */
	}

	q = get_sque(portid);
	if (!(q->openflag)) {	/* ץѤߤΥå */
		return(E_OBJ);
	}

	wai_sem(q->ssemid);
	for (i = 0; i < len; i++) {
		while((sil_reb_mem((VP)(q->base+TADR_SFR_UC1_OFFSET)) & 0x2) == 0);
		sil_wrb_mem((VP)(q->base+TADR_SFR_UTB_OFFSET), *buf++);
	}
	sig_sem(q->ssemid);
	return(len);
}

/*
 *  ꥢݡȤμ
 */

ER_UINT
serial_rea_dat(ID portid, char *buf, UINT len)
{
	SQUE	*q;
	UINT	i;

	if (!(1 <= portid && portid <= TNUM_SIOP)) {
		return(E_ID);		/* ݡֹΥå */
	}

	q = get_sque(portid);
	if (!(q->openflag)) {	/* ץѤߤΥå */
		return(E_OBJ);
	}

	for (i = 0; i < len; i++) {
		if (queue_size(q) == 0)
			wai_sem(q->rsemid);
		else
			pol_sem(q->rsemid);
		_syscall(loc_cpu());
		*buf++ = q->buffer[q->tail++];
		if (q->tail >= q->size) {
			q->tail = 0;
		}
		_syscall(unl_cpu());
	}
	return(len);
}

/*
 *  ꥢݡȤ
 */
ER
serial_ctl_por(ID portid, UINT ioctl)
{
	return(E_OK);
}

/*
 *  ꥢݡȾ֤λ
 */
ER
serial_ref_por(ID portid, T_SERIAL_RPOR *pk_rpor)
{
	SQUE	*q;

	if (sns_ctx()) {		/* ƥȤΥå */
		return(E_CTX);
	}
	if (!(1 <= portid && portid <= TNUM_SIOP)) {
		return(E_ID);		/* ݡֹΥå */
	}

	q = get_sque(portid);
	if (!(q->openflag)) {	/* ץѤߤΥå */
		return(E_OBJ);
	}

	pk_rpor->reacnt = queue_size(q);
	pk_rpor->wricnt = 0;
	return(E_OK);
}

/*
 *  ꥢݡȳߥӥ롼
 */

void
serial_handler_in(ID portid)
{
	SQUE	*q;
	int		rdata;				/* Хåե */

	q = get_sque(portid);
	if (queue_size(q) < q->size) {
		rdata = sil_reb_mem((VP)(q->base+TADR_SFR_URB_OFFSET));	/* ǡ */
		q->buffer[q->head++] = rdata;
		if (q->head >= q->size)
			q->head = 0;
		isig_sem(q->rsemid);
	}
}

/*
 *  ߥϥɥ
 */

void
serial_in_handler1(void)
{
	serial_handler_in(1);
}

void
serial_in_handler2(void)
{
	serial_handler_in(2);
}

