/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Ryosuke Takeuchi
 *              Platform Development Center RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.4 2006/08/03 04:15:57 honda Exp $
 */


/*
 *  ץå¸⥸塼M16Cѡ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

#ifdef NEED_API
#include "api.h"
#endif /* NEED_API */

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

/*
 *  ץåü̿Υ饤ؿ
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  TCB ΥեɤΥӥå
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */
#define TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */
#define TBIT_TCB_PRIORITY	4	/* priority եɤΥӥå */

#ifndef _MACRO_ONLY

/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	void	*sp;	/* åݥ(near) */
	FP		pc;	/* ץ५ */
} CTXB;

/* 
 *  /CPU㳰ͥȥ
 */
extern char	intnest;

/*
 *  ƥ֤λ
 */

/*
 *  ߤΥƥȤ֤ؿ.
 *  󥿥ƥȤʤTRUE֤.
 */
Inline BOOL
sense_context(void)
{
	/*  ͥȥ0ʤ󥿥ƥ  */
	return(intnest > 0);
}

/*
 *  ߤCPUå֤֤ؿ.
 *  CPUå֤ʤTRUE֤.
 */
Inline BOOL
sense_lock(void)
{
	return((current_flgreg() & FLG_I_MASK) == 0);
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβ
 */
Inline void
lock_cpu(void)
{
	disint();
}

Inline void
unlock_cpu(void)
{
	enaint();
}

#define t_lock_cpu	lock_cpu
#define i_lock_cpu	lock_cpu
#define t_unlock_cpu	unlock_cpu
#define i_unlock_cpu	unlock_cpu

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.a30
 *
 *  dispatch ϡƥȤƤӽФ줿
 *  ӥ椫顤CPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥå(cpu_support.a30)
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */

/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 *  ߥϥɥϿ٥ơ֥ROM˼,
 *  ˽񤭹. ΤᤳǤϲ⤷ʤ
 */

Inline void
define_inh(INHNO inhno, FP inthdr)
{
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr ꤹ롥
 *  ߥϥɥϿ٥ơ֥ROM˼,
 *  ˽񤭹. ΤᤳǤϲ⤷ʤ
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
}

/*
 *  ߥϥɥ顿CPU㳰ϥɥν
 *
 *  ߡCPU㳰ȯCPUξ֤ϼΤȤ.
 *
 *  FLG쥸IӥåȤ 0(߶ػ) 
 *  FLG쥸IPLϼդߤIPL
 *  FLG쥸UӥåȤ, ߤμˤäưۤʤ뤬,
 *  ͥǤISPΤߤѤ, USPѤƤʤ,
 *  ǤȤʤʤ.
 *
 *  /㳰ȯˤ, ưŪ FLG, PCå¸.
 *  ǤϤޤĤΥ쥸򥹥å¸.
 *  ʤγߤξϥΥå,
 *  ¿ųߤξϳѤΥå, 줾¸.
 *
 *  θ, åݥ󥿤ͤ r1 , 
 *  ߥϥɥΥɥ쥹 a1  a0 ˳Ǽ֤
 *  ߽θȾإפ.
 */

/*
 *  ߥϥɥνޥ
 *
 *  ȯ¹Υ쥸ͤ򥹥å򤹤롥θ塢
 *  åͤR1쥸˥åȤ֥ǵҤ줿ϥɥ
 *  ץʬ롥
 */

#define INTHDR_ENTRY(inthdr)\
extern void inthdr##_entry(void);\
asm("	.glb _" #inthdr "						");\
asm("	.glb __kernel_interrupt						");\
asm("	.section program, code, align					");\
asm("_" #inthdr "_entry:						");\
asm("	pushm	r0,r1,r2,r3,a0,a1,sb,fb	; 쥸򥿥å");\
asm("	stc	isp, r1			; åݥ󥿤Ф	");\
asm("	mov.w	#_" #inthdr "&0ffffh, a0; ߥϥɥβ2Х	");\
asm("	mov.w	#_" #inthdr ">>16, a1	; ߥϥɥξ2Х	");\
asm("	jmp	__kernel_interrupt	; ߽롼Ⱦ	");

#define INT_ENTRY(inthdr)	inthdr##_entry

/*
 *  CPU㳰ϥɥνޥ
 *
 *  CPU㳰ϥɥδŪʽϳߥϥɥȶͭ롥ߥ
 *  ɥȤΰ㤤ϥåͤ򤷤R1쥸ͤp_excinfȤ
 *  Ѥ뤫ʤκۤΤߤǤ
 */

#define EXCHDR_ENTRY(exchdr)\
extern void exchdr##_entry(void);\
asm("	.glb $" #exchdr "		 				");\
asm("	.glb __kernel_interrupt		 				");\
asm("	.section program, code, align					");\
asm("_" #exchdr "_entry:						");\
asm("	pushm	r0,r1,r2,r3,a0,a1,sb,fb	; 쥸򥿥å");\
asm("	stc	isp, r1			; åݥ󥿤Ф	");\
asm("	mov.w	#$" #exchdr "&0ffffh, a0; ߥϥɥβ2Х	");\
asm("	mov.w	#$" #exchdr ">>16, a1	; ߥϥɥξ2Х	");\
asm("	jmp	__kernel_interrupt	; ߽롼Ⱦ	");

#define EXC_ENTRY(exchdr) exchdr##_entry

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥȤλ
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	/* 
	 *  ͥȥ󥿤1ʤ󥿥ƥ
	 */
	return( intnest > 1);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	/*
	 *  㳰ȯFLG쥸IӥåȤ0ʤCPUå
	 *
	 *  18CPU㳰ǥ쥸åˤɤ
	 *  ¸Ƥ뤫˰¸Ʒꤹ
	 */
	return( ( *(char *)((char *)p_excinf+18) & FLG_I_MASK ) == 0);
}

/*
 *  ץå¸ν(cpu_config.c)
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ(cpu_config.c)
 */
extern void	cpu_terminate(void);

/*
 * 쥸ͥѹ
 */
extern void set_ic_ilvl(VP addr, UB val);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
