/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.h,v 1.7 2003/12/24 07:24:40 honda Exp $
 */

#ifndef _SYS_CONF_
/*
 *  OS μ
 */

/*
 *  ưåΥå̾
 */
#define	TARGET_NAME	"Linux"

/*
 *  CPU  _setjmp/_longjmp 饤֥μ˰¸
 *
 *  JMPBUF_PC: jmp_buf ¤ǡPC ͤΥեå
 *  JMPBUF_SP: jmp_buf ¤ǡSP ͤΥեå
 *
 *  STACK_MERGIN: åݥ󥿤νͤ򡤥åΰξ (
 *  ΰμ)  Υåݥ󥿤ؤ
 *  ϤȤϤץå ξˤϡȤäƥåݥ
 *  󥿤νͤ¤鲼롥ޤlongjmp ˡåݥ
 *  󥿤Ϥ ǽˤϡȤä
 *  ޡΰݤ롥
 *
 *  SIGSTACK_MERGIN: ʥ륹åץå˼Υޡ
 *  󡥥ȥåץ롼󤬻ȤΥåΰ补
 */

#if defined(i386) | defined(_i386_) | defined(__i386__)

#define JMPBUF_PC		JB_PC
#define JMPBUF_SP		JB_SP
#define STACK_MERGIN		4
#define SIGSTACK_MERGIN		8192

#else /* i386 */

#error not supported.

#endif /* i386 */

/*
 *  ʥ륹åѹ sigaltstack Ȥ
 */
#define USE_SIGALTSTACK

/*
 *  åꥢμ/ֵѴؿ mprotect ȤΤ˺
 */
#define	USE_MPROTECT_STACK



#ifdef _BSD_SERIAL_
#undef RAW			/* ͤ륷ܥ */
#undef ECHO
#endif /* _BSD_SERIAL_ */


/*
 *  ƥॿ˴ؤ
 */
#define	CONSOLE_PORTID	1	/* 󥽡ѤѤ륷ꥢݡֹ */
#define	LOGTASK_PORTID	1	/* ƥϤ륷ꥢݡֹ */
#define LOGTASK_STACK_SIZE 8192 /* Υå */

#ifndef _MACRO_ONLY
/*
 *  åȥƥ¸ν
 */
extern void	sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻ȤROM˥ƽФǼ¸뤳Ȥꤷ
 *  Ƥ롥
 */
extern void	sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼ROM˥ƽФǼ¸뤳
 *  ȤꤷƤ롥
 */
extern void	sys_putc(char c);

#endif /* _MACRO_ONLY */
#endif /* _SYS_CONF_ */



