/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#define _MACRO_ONLY

#include <t_config.h>	/* CCR_I, MAX_IPM */

/*
 *  H8Sѥȥåץ⥸塼
 *  ͥϥץꥱȥ󥯤ƻѤ
 *  ʤΤJSPͥΤ߻Ѥ롣
 */
	.h8300s

	.text
	.align 2

	.global	start
	.global bss_clear	/* hardware_init_hook ꥢɥ쥹 */

start:

	/*
	 *  ΩΥåSTACKTOP˽
	 *  STACKTOPϡsys_config.h
	 *  ϡɥޥ˥奢 4.2.4 ꥻåľγߡ(P90)
	 *    ץƬ̿ SP ν̿ǤʤФʤʤ
	 */
	mov.l	#STACKTOP, sp

	/*
	 *  CCR ν
	 *  ⡼0 ˤ߶ػ (I = 1 ; CCR)
	 *    ( _hardware_init_hook ǳ⡼ɤѹޤǤϡ
	 *     ⡼ɤ0Ǥ롣)
	 */
	ldc.b	#CCR_I, ccr

	/*
	 *  EXR ν
	 *  ⡼2 ˤ߶ػ (I2, I1, I0 = 1 ; CCR)
	 */
	ldc.b	#MAX_IPM, exr

	/*
	 *  hardware_init_hook ƤӽФ(0Ǥʤ)
	 *  åȥϡɥ˰¸ϡ
	 *    hardware_init_hook ȤؿѰդ롥
	 *      ROMκݡRAMѲǽˤ뤿ΥХȥν
	 *    ϡsys_support.S  hardware_init_hook Ƥ롥
	 */
hardware_init:
	mov.l	@_hardware_init_hook_k, er0
	or.l	er0, er0
	beq	bss_clear		/* er0 = 0 ʤ bss_clear  */
	jmp	@er0

	/*
	 * bss򥯥ꥢ
	 */
bss_clear:
	mov.l	#__bss_start, er0
	mov.l	#_end, er1
	sub.l	er2, er2
loop_bss_clear:
	mov.l	er2, @er0
	add.l	#4, er0
	cmp.l	er1, er0
	blo	loop_bss_clear		/* er1 > er0 ޤǥ */

	/*
	 *  dataROMб
	 *
	 *  __idata_start  __idata_end ޤǤ__data_start ʹߤ˥ԡ
	 */
data_sec_copy:
	mov.l	#__idata_start, er0
	mov.l	#__idata_end, er1
	mov.l	#__data_start, er2
loop_data_sec_copy:
	mov.l	@er0+, er4		/* *er2++ = *er0 ++; */
	mov.l	er4, @er2
	add.l	#4, er2
	cmp.l	er1, er0
	blo	loop_data_sec_copy	/* er1 > er0 ޤǥ */

	/*
	 *  software_init_hook ƤӽФ0 Ǥʤ
	 *
	 *  եȥĶä˥饤֥ˤ˰¸ɬפʽ
	 *  ϡsoftware_init_hook ȤؿѰդ롥
	 */
software_init:
	mov.l	@_software_init_hook_k, er0
	or.l	er0, er0
	beq	start_kernel
	jsr	@er0

	/*
	 *  ͥư
	 */
start_kernel:
	jmp	@_kernel_start

	.align 4
_hardware_init_hook_k:
	.long   _hardware_init_hook
_software_init_hook_k:
	.long   _software_init_hook
