/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

/*
 *	ꥢI/OǥХSIO˥ɥ饤СH8Sեߥ꡼ѡ
 */
#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <h8s_sci.h>

/*
 *  SIOγߥϥɥΥ٥ֹ
 */
/* ݡȣ */
#define INHNO_SERIAL1_ERROR	IRQ_ERI0
#define INHNO_SERIAL1_IN	IRQ_RXI0
#define INHNO_SERIAL1_OUT	IRQ_TXI0
#if TNUM_PORT >= 2
/* ݡȣ */
#define INHNO_SERIAL2_ERROR	IRQ_ERI1
#define INHNO_SERIAL2_IN	IRQ_RXI1
#define INHNO_SERIAL2_OUT	IRQ_TXI1
#endif /* TNUM_PORT */

/*
 *  SIOɥ饤Фν롼
 */
#define	sio_initialize		h8s_sci_initialize

/*
 *  ͥ뵯ưѤν (sys_putc)
 */
#define sio_init		h8s_sci_init

#ifndef _MACRO_ONLY

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  ץ󤷤ݡȤ뤫 openflag ɤǤ
	 */
	openflag = h8s_sci_openflag();

	/*
	 * ⥸塼륹ȥåץ⡼ɲ
	 */
#if TNUM_SIOP < 2
	h8s_andh( (VP) MSTPCR, ~( BIT5 ) );
#else /* TNUM_SIOP < 2 */
	h8s_andh( (VP) MSTPCR, ~( BIT6 | BIT5 ) );
#endif /* TNUM_SIOP < 2 */

	/*
	 *  ǥХ¸Υץ
	 */
	siopcb = h8s_sci_opn_por(siopid, exinf);

	/*
	 *  ꥢI/Oߤγߥ٥ꤹ롣
	 */
	if (!openflag) {
		/* ߥ٥ */
#ifndef GDB_STUB	/* SCI0  GDB_STUB Ѥ롣 */
		icu_set_ilv( (VP) IPRJ, IPR_LOW, SCI0_INT_LVL );
#endif /* GDB_STUB */
#if TNUM_SIOP >= 2
		icu_set_ilv( (VP) IPRK, IPR_UPR, SCI1_INT_LVL );
#endif /* TNUM_SIOP >= 2 */
	}
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  ǥХ¸Υ
	 */
	h8s_sci_cls_por(siopcb);

	/*
	 *  ⥸塼륹ȥåץ⡼ɥå
	 */
#if TNUM_SIOP < 2
	h8s_orh( (VP) MSTPCR,   BIT5 );
#else /* TNUM_SIOP < 2 */
	h8s_orh( (VP) MSTPCR, ( BIT6 | BIT5 ) );
#endif /* TNUM_SIOP < 2 */

	/*
	 *  ꥢI/Oߤޥ롣
	 */
	if (!h8s_sci_openflag()) {
		/* ߥޥ */
#ifndef GDB_STUB	/* SCI0  GDB_STUB Ѥ롣 */
		icu_set_ilv( (VP) IPRJ, IPR_LOW, 0 );
#endif /* GDB_STUB */
#if TNUM_SIOP >= 2
		icu_set_ilv( (VP) IPRK, IPR_UPR, 0 );
#endif /* TNUM_SIOP >= 2 */
	}
}

#endif /* _MACRO_ONLY */

/*
 *  SIOγߥϥɥ
 *    sio1_handler_in    : ߥϥɥ
 *    sio1_handler_out   : ߥϥɥ
 *    sio1_handler_error : 顼ߥϥɥ
 */
/* ݡȣ */
#define	sio1_handler_in		h8s_sci0_isr_in
#define	sio1_handler_out	h8s_sci0_isr_out
#define	sio1_handler_error	h8s_sci0_isr_error
#if TNUM_SIOP >= 2
/* ݡȣ */
#define	sio2_handler_in		h8s_sci1_isr_in
#define	sio2_handler_out	h8s_sci1_isr_out
#define	sio2_handler_error	h8s_sci1_isr_error
#endif /* TNUM_SIOP >= 2 */

/*
 *  ꥢI/OݡȤؤʸ
 */
#define	sio_snd_chr		h8s_sci_snd_chr

/*
 *  ꥢI/OݡȤؤʸʥݡ󥰡
 */
#define	sio_snd_chr_pol		h8s_sci0_putchar_pol

/*
 *  ꥢI/OݡȤʸ
 */
#define	sio_rcv_chr		h8s_sci_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define	sio_ena_cbr		h8s_sci_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define	sio_dis_cbr		h8s_sci_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 */
#define	sio_ierdy_snd		h8s_sci_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 */
#define	sio_ierdy_rcv		h8s_sci_ierdy_rcv

#endif /* _HW_SERIAL_H_ */
