/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

/*
 *  ץå¸⥸塼(H8S)
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/*
 *  ƥȤǤγߥޥ
 */
#ifdef SUPPORT_CHG_IPM
volatile IPM	task_intmask = 0;		/* IPM -> UB̵8ӥå */
#endif /* SUPPORT_CHG_IPM */

/*
 *  󥿥ƥȤǤγߥޥ
 */
volatile IPM	int_intmask = 0;

/*
 *  ߥͥȥ
 */
volatile UB	intnest = 1;

/*
 *  CPUå֤ɽե饰
 *  ߶ػߡʥͥγߤΤߡ
 *  
 *  iscpulocked == TRUE
 *  ΤȤCPUå֤Ȥ롣
 */
volatile BOOL     iscpulocked = TRUE;

/*
 *  ץå¸ν
 */
void cpu_initialize(void) {

        /*
         *  ʲ4Ĥϥȥåץ롼ǽѤǤ롣
         *  ߥͥȥ intnest = 1;
         *  󥿥ƥȤγߥޥ int_intmask = 0;
         *  ƥȤγߥޥ task_intmask = 0;
         *  chg_ipm򥵥ݡȤ
         *  CPUåե饰 iscpulocked = TRUE;
         */

	/* ⡼ɤ */
	h8s_wrb_reg(SYSCR, SYS_SYSCR);

	/* ߥ٥ν */
	h8s_wrb_reg(IPRA, 0);
	h8s_wrb_reg(IPRB, 0);
	h8s_wrb_reg(IPRC, 0);
	h8s_wrb_reg(IPRD, 0);
	h8s_wrb_reg(IPRE, 0);
	h8s_wrb_reg(IPRF, 0);
	h8s_wrb_reg(IPRG, 0);
	h8s_wrb_reg(IPRH, 0);
	h8s_wrb_reg(IPRI, 0);
	h8s_wrb_reg(IPRJ, 0);
	h8s_wrb_reg(IPRK, 0);
}

/*
 *  ץå¸νλ
 */
void cpu_terminate(void) {
}

/*
 * Ԥ
 * ջࡧ
 * ɸǤdlytimUINT16ӥåȤʤΤǡ
 * UWѹƤ롣
 * sil_dly_nse()sil_dly_nse_long()ƤӽФ
 */
void sil_dly_nse(UINT dlytim) {
	sil_dly_nse_long((UW)dlytim);
}

#ifdef SUPPORT_CHG_IPM

/*
 *  ߥޥѹ
 *
 *IPMǤͤ0MAX_IPMǤ롣
 *ߥץ饤ƥ٥뤬(MAX_IPM+1)ʾγߤϥͥ
 *Ǥ롣
 *
 *  IPM  0 ʳλˤ⡤ǥѥåαʤ
 *  ǥѥåػߤˤϡloc_cpu ˤCPUå֤
 *  Ф褤IPM ϡ
 *  ǥѥåˤäơ¹Ծ֤ˤʤäذѤ
 *  롥Τᡤ¹ˡ̤Υˤä IPM ѹ
 *  礬롥JSPͥǤϡIPM ѹϥ㳰롼
 *  ˤäƤⵯΤˤäư񤷤ʤϾʤ
 *  פ롥
 *IPM ͤˤäƥǥѥåػߤˤϡdis_dsp
 *  ʻѤФ褤
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
        ER      ercd = E_OK;

        LOG_CHG_IPM_ENTER(ipm);
        CHECK_TSKCTX_UNL();
        CHECK_PAR(ipm <= MAX_IPM);

        t_lock_cpu();
        task_intmask = ipm;
        t_unlock_cpu();

    exit:
        LOG_CHG_IPM_LEAVE(ercd)
        return(ercd);
}

/*
 *  ߥޥλ
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
        ER      ercd = E_OK;

        LOG_GET_IPM_ENTER(p_ipm);
        CHECK_TSKCTX_UNL();

        t_lock_cpu();
        *p_ipm = task_intmask;
        t_unlock_cpu();

    exit:
        LOG_GET_IPM_LEAVE(ercd, *p_ipm);
        return(ercd);
}


#endif /* SUPPORT_CHG_IPM */

/*============================================================================*/
/*  ̥ɥȤˤϤʤȼʬ  */

/*
 * ϿƤʤߤȯȸƤӽФ
 */
void 
cpu_experr(EXCSTACK *sp)
{
    UW sp2, pc, ccr, tmp;
    
    sp2 = (UW)sp + OFFSET_SP;
    tmp = sp->pc;
    ccr = (tmp >> 24U) & 0xff;	/*  1Х  */
    pc = tmp & 0x00ffffffUL;	/*  3Х  */
    
    syslog(LOG_EMERG, "Unexpected interrupt.");
    syslog(LOG_EMERG, "PC  = 0x%08lx SP  = 0x%08lx CCR  = 0x%02x",
                       (VP)pc, (VP)sp2, (INT)ccr);
    syslog(LOG_EMERG, "EXR  = 0x%02x", (INT)(sp->exr));
    syslog(LOG_EMERG, "ER0 = 0x%08lx ER1 = 0x%08lx ER2 = 0x%08lx ER3 = 0x%08lx",
           (VP)(sp->er0), (VP)(sp->er1), (VP)(sp->er2), (VP)(sp->er3));
    syslog(LOG_EMERG, "ER4 = 0x%08lx ER5 = 0x%08lx ER6 = 0x%08lx",
                       (VP)(sp->er4), (VP)(sp->er5), (VP)(sp->er6));
    while(1)
    	;
}


/*============================================================================*/
/*  ǥХåѥ  */

#ifdef TEST_CPU_INSN

volatile UB ccr, exr;
volatile IPM intmask;

void test_cpu_insn(void)
{
	ccr = current_ccr();
	set_ccr(0xf);
	ccr = current_ccr();

	exr = current_exr();
	set_exr(0x7);
	exr = current_exr();

	intmask = current_intmask();
	set_intmask(0x3);
	intmask = current_intmask();
	
	disint();
	enaint();
	
	_disint_();
}

#endif /* TEST_CPU_INSN */


#ifdef TEST_CPU_CONFIG

volatile BOOL b;
volatile ER err;
volatile IPM ipm;

void dummy(void)
{
}

void test_cpu_config(void)
{
	b = sense_context();
	dummy();
	intnest = 1;
	dummy();
	b = sense_context();
	dummy();
	intnest = 0;
	dummy();
	b = sense_context();
	dummy();

	b = t_sense_lock();
	dummy();
	t_lock_cpu();
	dummy();
	b = t_sense_lock();
	dummy();
	t_unlock_cpu();
	dummy();
	b = t_sense_lock();
	dummy();

	i_lock_cpu();
	dummy();
	b = i_sense_lock();
	dummy();
	i_unlock_cpu();
	dummy();
	b = i_sense_lock();
	dummy();
	
	err = chg_ipm(6);
	dummy();
	err = get_ipm(&ipm);
	dummy();
	err = chg_ipm(3);
	dummy();
	err = get_ipm(&ipm);
	dummy();
	err = chg_ipm(8);
	dummy();
}

#endif /* TEST_CPU_CONFIG */

#ifdef TEST_H8S_SIL

volatile UB ddr;

void test_h8s_sil(void)
{
	ddr = sil_reb_ddr(IO_PORT7);
	sil_wrb_ddr(IO_PORT7, 0xff);
	ddr = sil_reb_ddr(IO_PORT7);
	sil_anb_ddr(IO_PORT7, 0xf);
	ddr = sil_reb_ddr(IO_PORT7);
	sil_orb_ddr(IO_PORT7, 0x80);
	ddr = sil_reb_ddr(IO_PORT7);
}

#endif /* TEST_H8S_SIL */



