/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: hw_serial.h,v 1.7 2007/03/23 07:58:33 honda Exp $
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

/*
 *  åȰ¸ꥢI/O⥸塼H8ѡ
 *    ݡȤ 1ܤξ HWPORT1_ADDR˻ꤵ줿ݡȤѤ
 *      2ܤξϡHWPORT1_ADDR桼ѡHWPORT2_ADDR򥳥󥽡
 *      ϤȤƻѤ롣
 *      HWPORTx_ADDR åȰ¸ sys_config.hǻꤹ롣
 *    Υ⥸塼ˤäơXON/XOFFե椬Ԥ
 *      ƤΤǡTxDRxD2ܤǤ褤
 */

#include <s_services.h>
#include <h8_sil.h>

#ifndef _MACRO_ONLY

/*
 *  ꥢݡȤν֥å
 */
typedef struct sio_port_initialization_block {
        UB      *base;          /* SCI Υ١ɥ쥹 */
        UW      baudrate;       /* ܡ쥤           */
        IRC     irc;            /* ߥ٥ */
        UB      smr_init;       /* SMR          */
} SIOPINIB;

/*
 *  ꥢݡȤ֥å
 */

typedef struct sio_port_control_block {
        const SIOPINIB  *inib;          /* ֥å       */
        VP_INT          exinf;          /* ĥ             */
        BOOL            openflag;       /* ץѤߥե饰   */
} SIOPCB;

extern SIOPCB siopcb_table[TNUM_PORT];

/*
 *  SIO ID ֥åؤѴ
 */
#define INDEX_SIO(sioid)        ((UINT)(sioid) - 1u)

Inline SIOPCB*
get_siopcb(ID sioid)
{
	UINT index = INDEX_SIO(sioid);
	
	assert(index < TNUM_PORT);
	
    return(&(siopcb_table[index]));
}

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND            1u              /* ǽХå                 */
#define SIO_ERDY_RCV            2u              /* ΥХå                 */

/*
 *  SCI ؿλ
 */
extern void     SCI_initialize (ID sioid);      /* SCI ν                         */
extern void     SCI_cls_por(UB *base);          /* SCI Υ                       */
extern void     SCI_in_handler(ID sioid);       /* SCI ϳߥϥɥ             */
extern void     SCI_out_handler(ID sioid);      /* SCI ϳߥϥɥ             */
extern void     SCI_err_handler(ID sioid);      /* SCI ϥ顼ߥϥɥ       */
extern void     SCI_ierdy_snd(VP_INT exinf);    /* ꥢ I/O ǽХå */
extern void     SCI_ierdy_rcv(VP_INT exinf);    /* ꥢ I/O μΥХå */

/*
 *  SCI ٥δؿ
 */

/*
 *  SCI Υץ
 */
Inline SIOPCB *
SCI_opn_por (ID sioid)
{
        SCI_initialize(sioid);
        return get_siopcb(sioid);
}

/*
 *  SCI_putchar -- ʸν񤭹
 */
Inline void
SCI_putchar(const SIOPCB *p, UB c)
{
        UB *base_addr = p->inib->base;

        sil_wrb_mem((VP)(base_addr + H8TDR), (VB)c);
        bitclr(base_addr + H8SSR, (UB)H8SSR_TDRE_BIT);
}


/*
 *  ٥ϤѤ륷ꥢݡȤ
 *  椹쥸Ƭɥ쥹
 */
#if SCI_LOW_PORTID == SCI_PORTID1
#define SCI_LOW_BASE			SCI_PORT1_BASE
#else /* SCI_LOW_PORTID == SCI_PORTID1 */
#define SCI_LOW_BASE			SCI_PORT2_BASE
#endif

/*
 *  SCI_putchar_pol -- ݡˤ٥
 */
Inline void
SCI_putchar_pol(UB c)
{
        UB *base = (UB*)SCI_LOW_BASE;
        UB *addr = base + H8SSR;
        UB tdre = 0;

        /* TDREåȤޤԤ */
        while (tdre == 0) {
			/*  ѥηٹ뤿ᡢ㥹ȤƤ  */
			tdre = (UB)((UB)sil_reb_mem((VP)addr) & H8SSR_TDRE);
		}
        sil_wrb_mem((VP)(base + H8TDR), (VB)c);
        bitclr(addr, (UB)H8SSR_TDRE_BIT);
}

/*
 *  SCI_getchar -- ʸɤ߽Ф
 */
Inline INT
SCI_getchar(const SIOPCB *p)
{
        UB      *base_addr = p->inib->base;
        INT     ch = (UB)sil_reb_mem((VP)(base_addr + H8RDR));
                /* UB Υ㥹Ȥϡĥɻߤ뤿 */

        bitclr(base_addr + H8SSR, (UB)H8SSR_RDRF_BIT);
        return ch;
}

/*
 *  SCI_putready -- ǽ
 */
Inline BOOL
SCI_putready(const SIOPCB *pcb)
{
        BOOL ret = TRUE;
        UB ssr = sil_reb_mem((VP)(pcb->inib->base + H8SSR));
        
        ssr &= (UB)H8SSR_TDRE;
        if (ssr == 0) {
			ret = FALSE;
		}
        return(ret);
}

/*
 *  SCI_getready -- ǽ
 */
Inline BOOL
SCI_getready(const SIOPCB *pcb)
{
        BOOL ret = TRUE;
        UB ssr = sil_reb_mem((VP)(pcb->inib->base + H8SSR));

        ssr &= (UB)H8SSR_RDRF;
        if (ssr == 0) {
			ret = FALSE;
		}
        return(ret);
}

/*
 *  ؿ
 */
Inline void
SCI_enable_send(const SIOPCB *p)
{
        UB *addr = p->inib->base + H8SCR;
        bitset(addr, (UB)H8SCR_TIE_BIT);
}

Inline void
SCI_disable_send(const SIOPCB *p)
{
        UB *addr = p->inib->base + H8SCR;
        bitclr(addr, (UB)H8SCR_TIE_BIT);
}

/*
 *  ؿ
 */
Inline void
SCI_enable_recv(const SIOPCB *p)
{
        UB *addr = p->inib->base + H8SCR;
        bitset(addr, (UB)H8SCR_RIE_BIT);
}

Inline void
SCI_disable_recv(const SIOPCB *p)
{
        UB *addr = p->inib->base + H8SCR;
        bitclr(addr, (UB)H8SCR_RIE_BIT);
}

/*
 *  SIO ؿλ
 */
                                /* SCI ν                         */
extern void     sio_initialize(void);
                                /* ꥢ I/O ΥХå  */
extern void     sio_ena_cbr(SIOPCB *pcb, UINT cbrtn);
                                /* ꥢ I/O ΥХåػ  */
extern void     sio_dis_cbr(SIOPCB *pcb, UINT cbrtn);

/*
 *  ؿߥ졼ޥ
 */
                        /* ꥢ I/O ǽХå      */
#define sio_ierdy_snd(e)        SCI_ierdy_snd(e)
                        /* ꥢ I/O μΥХå      */
#define sio_ierdy_rcv(e)        SCI_ierdy_rcv(e)

/*
 *  SIO ٥δؿ
 */

extern void sio_in_handler (void);
extern void sio_out_handler (void);

#ifdef H8_CFG_SCI_ERR_HANDLER
extern void sio_err_handler (void);
#endif  /* of #ifdef H8_CFG_SCI_ERR_HANDLER */

#if TNUM_PORT >= 2u
extern void sio_in2_handler (void);
extern void sio_out2_handler (void);

#ifdef H8_CFG_SCI_ERR_HANDLER
extern void sio_err2_handler (void);
#endif  /* of #ifdef H8_CFG_SCI_ERR_HANDLER */

#endif  /* of #if TNUM_PORT >= 2u */

/*
 *  sio_opn_por -- ݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID sioid, VP_INT exinf)
{
        SIOPCB  *pcb = SCI_opn_por(sioid);

        pcb->exinf    = exinf;
        pcb->openflag = TRUE;
        return pcb;
}

/*
 *  sio_cls_por -- ݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *pcb)
{
        SCI_cls_por(pcb->inib->base);
        pcb->openflag = FALSE;
}

/*
 *  sio_snd_chr -- ʸ
 */
Inline BOOL
sio_snd_chr(const SIOPCB *pcb, char chr)
{
        BOOL ret = FALSE;
        if (SCI_putready(pcb) == TRUE) {
                SCI_putchar(pcb, (UB)chr);
                ret = TRUE;
        }
        return ret;
}

/*
 *  sio_rcv_chr -- ʸ
 */
Inline INT
sio_rcv_chr(const SIOPCB *pcb)
{
        INT ret = 0;
        if (SCI_getready(pcb) == TRUE) {
                ret = SCI_getchar(pcb);
        } else {
                ret = -1;
        }
        return(ret);
}

#endif  /* of #ifndef _MACRO_ONLY */

#endif /* _HW_SERIAL_H_ */
