/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN  
 *  Copyright (C) 2007 by KURUSUGAWA Electronics Technology Inc
 *  Copyright (C) 2008 by Takahisa Yokota
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.9 2003/07/08 14:57:15 hiro Exp $
 */

/*
 *  CPU¸ޥ⥸塼SH7145ѡ
 *  PIT
 *ޥǥХΤ˰¸mcfpit.h˵Ҥ
 */
#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>

#ifndef _MACRO_ONLY
#include "mcfpit.h"
#endif /* _MACRO_ONLY */

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	MCF_PIT0

#ifndef _MACRO_ONLY

/*
 *  ޳׵Υꥢ
 */
#define hw_timer_int_clear	mcf_timer_int_clear

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
	/*
	 *  ޥǥХΤν
	 */
	mcf_timer_initialize();

	/*
	 *  ߴϢ
	 */
	/* ߥ٥   */
        /* Set tic for timers	*/
        sil_wrb_mem (MCF_INTC_ICR(MCF_INTC0, 55), ((TIMER_INTLVL) << 3) | (TIMER_INTPRI));
        sil_wrw_mem (MCF_INTC_IMRH(MCF_INTC0), sil_rew_mem(MCF_INTC_IMRH(MCF_INTC0)) & (~(1 << (TBIT_TT0))));
        mcf_timer_int_clear();
        mcf_timer_start();
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
#define hw_timer_terminate		mcf_timer_terminate

/*
 *  ޤθͤɽФ
 */
#define hw_timer_get_current		mcf_timer_get_current

/*
 *  ޳׵Υå
 */
#define hw_timer_fetch_interrupt        mcf_timer_fetch_interrupt

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
