/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_context.h,v 1.6 2003/12/01 06:47:05 honda Exp $
 */


/*
 *  ƥ롼ARMv4ѡ
 *
 *  Υե cpu_conf.h ʬΥƤΤϡΥեTCB
 *  줿ɤɬפΤФơcpu_conf.h ˤTCB
 *  ɤɬפޤǤ뤿Ǥ롥
 */

#ifndef _CPU_CONTEXT_H_
#define _CPU_CONTEXT_H_

#include "task.h"

/*
 *  ƥȥ֥åν
 *
 *  ٻ߾֤˰ܹԤʥνλˤ˸
 *  Ф롥Ūˤϡƥȥ֥å򥿥ưǤ
 *  ֤ꤹcreate_context  activate_context ǹԤ
 *  褤¿νϤɤδؿǹԤäƤ褤
 */
Inline void
create_context(TCB *tcb)
{
}

/*
 *  εư
 *
 *  ٻ߾֤¹ԤǤ֤˰ܹԤ˸ƤФ롥
 *  
 */
extern void	activate_r(void);

Inline void
activate_context(TCB *tcb)
{
	VW	*sp;

    sp = (VW *)(((SIZE) tcb->tinib->stk) + tcb->tinib->stksz);
	*--sp = (VW)(tcb->tinib->task);    
	*--sp = (VW)(tcb->tinib->exinf);
	tcb->tskctxb.sp = sp;
	tcb->tskctxb.pc = activate_r;
}


/*
 *  ext_tsk å˳ݤߡΰΥ
 *  
 */
#define	ACTIVATED_STACK_SIZE	(sizeof(VW) * 2)

/*
 *  calltex ϻѤʤ
 */
#define OMIT_CALLTEX

#endif /* _CPU_CONTEXT_H_ */







