/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                2003      by Advanced Data Controls, Corp
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_insn.h,v 1.3 2003/12/19 11:24:37 honda Exp $
 */

/*
 *   ץåü̿Υ饤ؿARMv4ѡ
 */

#ifndef _CPU_INSN_H_
#define _CPU_INSN_H_

#include <armv4.h>

#define CPU_BITMAP_SEARCH 
#define bitmap_search(bitmap)     (ffs(bitmap)-1)

/*
 *  쥸ؿ
 */

/*
 *  ơ쥸CPSRˤθͤɽФ
 */
asm 
unsigned int current_sr()
{
%
    mrs    r0,CPSR    
}
/*
 *  ơ쥸CPSRˤθͤѹ
 */
asm 
void set_sr(s)
{
%reg s
   msr     CPSR,s
}


/*
 *  IRQߤػ
 */
Inline void
disint(void)
{
    set_sr(current_sr() | CPSR_IRQ_BIT);
}


/*
 *  IRQߤ
 */
Inline void
enaint()
{
    set_sr(current_sr() & ~CPSR_IRQ_BIT);
}


#endif /* _CPU_INSN_H_ */
