/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: collection.h,v 1.6 2003/12/20 06:51:58 takayuki Exp $
 */

// $Header: /home/CVS/configurator/base/collection.h,v 1.6 2003/12/20 06:51:58 takayuki Exp $

#ifndef COLLECTION_H
#define COLLECTION_H

#include "base/testsuite.h"
#include "base/singleton.h"

#include <typeinfo>
#include <list>

    //CollectionϿ֥ȤΥ饹δ쥯饹
class Collectable
{
public:
             Collectable(void) throw() {}   //ä˲⤷ʤ
    virtual ~Collectable(void) throw() {}   //ä˲⤷ʤ
};



    //뷿Υ󥹥󥹤Ͽݻ뤿Υ饹
class Collection
{
public:
    struct Element
    {
        Collectable * instance;
        bool          destruction;
    };

protected:
    std::list<Element> container;

        //predecessorμؤƥ졼 (getInstance)
    std::list<Element>::const_iterator _findInstance(const Collectable * predecesor) const throw();

public:
        //󥹥ȥ饯 & ǥȥ饯
             Collection(void)  throw();
    virtual ~Collection(void) throw();

        //ͭȽ
    inline bool isValid(void) const throw()
    {   return this != 0;   }

        //쥯ؤɲ (ݥ)
    bool addInstance(Collectable * instance, bool destruction = true)  throw();
    
        //쥯ؤɲ ()
    inline bool addInstance(Collectable & instance, bool destruction = false) throw()
    {   return addInstance(&instance, destruction);   }

        //쥯󤫤μ ()
    Collectable * getInstance(const std::type_info & type, const Collectable * predecessor = 0) const throw();

        //쥯󤫤μ (Τ⥵)
    template<class T> T * getInstance(const Collectable * predecessor = 0) const throw()
    {
        T * result = 0;

        if(isValid()) {
            std::list<Element>::const_iterator iterator = _findInstance(predecessor);

            while(iterator != container.end()) {
                result = dynamic_cast<T *>(iterator->instance);
                if(result != 0)
                    break;
                ++ iterator;
            }
        }
        return result;
    }

        //쥯󤫤ޤƤΥ饹󥹥󥹤 (˴оݤξ˴Ԥ)
    template<class T> void deleteInstance(void) throw()
    {
        if(isValid()) {
            std::list<Element>::iterator iterator;

            iterator = container.begin();
            while(iterator != container.end()) {
                if(dynamic_cast<T *>(iterator->instance) != 0) {

                        //оݤʤ饤󥹥󥹤
                    if(iterator->destruction)
                        delete iterator->instance;

                        //ꥹȤ
                    std::list<Element>::iterator target = iterator;
                    ++ iterator;
                    container.erase(target);
                }
                else
                    ++ iterator;
            }
        }
    }

        //Ϣդ줿󥹥󥹤ؤ
    template<class T> inline bool replaceInstance(Collectable * instance, bool destruction = true) throw()
    {
            //ʬ̵طʥ饹ϥǥåȤƻǤʤ
        if(dynamic_cast<T *>(instance) == 0)
            return false;

        deleteInstance<T>();
        return addInstance(instance, destruction);
    }

        //Ϣդ줿󥹥󥹤ؤ
    template<class T> inline bool replaceInstance(Collectable & instance, bool destruction = false) throw()
    {
            //ʬ̵طʥ饹ϥǥåȤƻǤʤ
        if(dynamic_cast<T *>(&instance) == 0)
            return false;

        deleteInstance<T>();
        return addInstance(&instance, destruction);
    }


        //쥯󤫤饤󥹥󥹤 (˴Ϥʤ)
    bool removeInstance(const Collectable * instance) throw();

        //Ǥ˴
    void clear(void);

    TESTSUITE_PROTOTYPE(main)
};


    //¹Ի֥Ȼȥơ֥
class RuntimeObjectTable : protected Collection
{
friend class RuntimeObject;
public:
    SINGLETON_CONSTRUCTOR(RuntimeObjectTable) throw() {}

    static Collectable * getInstance(const std::type_info & type, const Collectable * predecessor = 0) throw()
    {
        RuntimeObjectTable * table = Singleton<RuntimeObjectTable>::getInstance(std::nothrow);
        Collectable * result = 0;

        if(table != 0)
            result = table->Collection::getInstance(type, predecessor);
        return result;
    }

        //쥯󤫤μ (Τ⥵)
    template<class T> static T * getInstance(const Collectable * predecessor = 0) throw()
    {
        RuntimeObjectTable * table = Singleton<RuntimeObjectTable>::getInstance();
        T * result = 0;

        if(table != 0) {
            std::list<Element>::const_iterator iterator = table->_findInstance(predecessor);

            while(iterator != table->container.end()) {
                result = dynamic_cast<T *>(iterator->instance);
                if(result != 0)
                    break;
                ++ iterator;
            }
        }
        return result;
    }

        /* Visual C++ 6.0 Fatal error C1001к */
    template<class T> static T * getInstance(T ** dest, const Collectable * predecessor = 0) throw()
    {
        RuntimeObjectTable * table = Singleton<RuntimeObjectTable>::getInstance();
        T * result = 0;

        if(table != 0) {
            std::list<Element>::const_iterator iterator = table->_findInstance(predecessor);

            while(iterator != table->container.end()) {
                result = dynamic_cast<T *>(iterator->instance);
                if(result != 0)
                    break;
                ++ iterator;
            }
        }
        if(dest != 0)
            *dest = result;

        return result;
    }

    TESTSUITE_PROTOTYPE(main)
};

    //¹Ի֥
class RuntimeObject : public Collectable
{
public:
    RuntimeObject(bool destruction = false) throw()
    {
        RuntimeObjectTable * table = Singleton<RuntimeObjectTable>::getInstance();
        if(table != 0)
            table->addInstance(this, destruction);
    }

    virtual ~RuntimeObject(void) throw()
    {
        RuntimeObjectTable * table = Singleton<RuntimeObjectTable>::getInstance();
        if(table != 0)
            table->removeInstance(this);
    }
};

    /*  fatal error C1001: INTERNAL COMPILER ERROR (msc1.cpp:1794) */
#if _MSC_VER < 1300 
#  define getRuntimeObjectInstance(x) (dynamic_cast<x *>(RuntimeObjectTable::getInstance(typeid(x))))       //ΤˤƩǤϤʤƨ뤷ʤ
#else
#  define getRuntimeObjectInstance(x) (RuntimeObjectTable::getInstance<x>())
#endif


#endif



