package je.tn5250j.settings;

/**
 * @author user
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
import java.awt.*;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Properties;

import javax.swing.*;
import javax.swing.filechooser.FileFilter;

import je.tn5250j.gui.TN5250jFileChooser;
import je.tn5250j.tools.*;
import je.tn5250j.GlobalConfigure;
import je.tn5250j.SessionConfig;
import je.tn5250j.TN5250jConstants;
import je.tn5250j.interfaces.ConfigureFactory;

public class KeyboardAttributesPanel extends AttributesPanel implements TN5250jConstants {

	JCheckBox kbCheck;
	JTextField keymapText;
	JButton keymapButton;
	
	Properties sesprop;
	JPanel selectkmp;
	
	String keymapPath_bak;
	
	final String kwd1 = "keybuffer";
	final String kwd2 = "keymapPath";

	public KeyboardAttributesPanel(SessionConfig config) {
		super(config, "Keyboard");
	}

	/**Component initialization*/
	public void initPanel() throws Exception {

		setLayout(new BorderLayout());
		contentPane = new JPanel();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
		add(contentPane, BorderLayout.NORTH);

		// define keyboard buffer Control panel
		JPanel kbp = new JPanel();
		kbp.setBorder(
			BorderFactory.createTitledBorder(LangTool.getString("sa.kbp")));
		kbCheck = new JCheckBox(LangTool.getString("sa.kbCheck"));

		String kwdp= getStringProperty(kwd1);
		if (kwdp.length() == 0 || kwdp.equals("Yes"))
			kbCheck.setSelected(true);
			
		kbp.add(kbCheck);
/*		
		// define keyboard mapping file panel
		JPanel keymapp = new JPanel();
		keymapp.setBorder(
			BorderFactory.createTitledBorder(LangTool.getString("sa.keymapp")));
		keymapText = new JTextField(50);
		
		String keymapPath = getStringProperty(kwd2);
		if (keymapPath.length() == 0){
			keymapText.setText(System.getProperty("user.home") + "\\.tn5250j\\keymap");
		}else{
			keymapText.setText(getStringProperty("keymapPath"));
			keymapPath_bak = getStringProperty("keymapPath");
		}

		keymapButton = new JButton(LangTool.getString("sa.kmButton"));
		keymapButton.setActionCommand("keymap");
		keymapButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser chooser = new JFileChooser();
				JFileFilter filter = new JFileFilter();
				filter.description = LangTool.getString("sa.kmExtension");
				filter.extention = "kbd";
				File file = new File(".\\");
				chooser.setCurrentDirectory(file);
				chooser.setFileFilter(filter);
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				int returnVal = chooser.showOpenDialog(keymapButton);
				if(returnVal == chooser.APPROVE_OPTION){
					keymapText.setText(chooser.getSelectedFile().getAbsolutePath());
				}
			}
		});
		
		keymapp.add(keymapText);
		keymapp.add(keymapButton);
*/
		contentPane.add(kbp);
//		contentPane.add(keymapp);
	}

	public void save() {

	}

	public boolean applyAttributes() {

		if (kbCheck.isSelected()) {
			changes.firePropertyChange(
				this,
				kwd1,
				getStringProperty(kwd1),
				"Yes");
			setProperty(kwd1, "Yes");
		} else {
			changes.firePropertyChange(
				this,
				kwd1,
				getStringProperty(kwd1),
				"No");
			setProperty(kwd1, "No");
		}
/*		
		if (!keymapText.getText().equals(keymapPath_bak)) {
			File kmpFile = new File(keymapText.getText());
			if(kmpFile.exists()){
				changes.firePropertyChange(
					this,
					kwd2,
					getStringProperty(kwd2),
					keymapText.getText());
				setProperty(kwd2, keymapText.getText());
			} else {
				JOptionPane.showMessageDialog(null,
					LangTool.getString("sa.kmMessage1")+keymapText.getText()+LangTool.getString("sa.kmMessage2"), 
					LangTool.getString("sa.kmWarning"), 
					JOptionPane.OK_OPTION);
				return false;
			}
		}
*/	
		return (true);
	}
	
}

class JFileFilter extends FileFilter{
    String description;
    String extention;

    public String getDescription(){
        if(description != null){
        	return description;
        }
        return null;
    }

    public boolean accept(File f) {
    	if(f != null) {
        	if(f.isDirectory()) {
            	return true;
            }
            if(extention.equals("") || extention == null){
            	return true;	
            }
            if(f.getName().toLowerCase().endsWith(extention)){
            	return true;
            }
        }
    	return false;
	}
}
