/**
 * Title: DefaultKeyboardHandler
 * Copyright:   Copyright (c) 2001, 2002
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.5
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j.keyboard;

import java.awt.event.*;
import je.tn5250j.Session;
import je.tn5250j.Screen5250;
import je.tn5250j.event.KeyChangeListener;
import je.tn5250j.tnvt;
import javax.swing.*;

/**
 *
 */
public abstract class KeyboardHandler
	extends KeyAdapter
	implements je.tn5250j.TN5250jConstants, KeyChangeListener {
	protected Session session;
	protected Screen5250 screen;
	protected boolean isLinux;
	protected boolean isAltGr;
	protected boolean keyProcessed = false;
	protected KeyMapper keyMap;
	protected String lastKeyStroke = null;
	protected StringBuffer recordBuffer;
	protected boolean recording;
	// add pei 070124 p
	protected boolean released = true;

	/**
	 * Creates a new keyboard handler.
	 * @param session The session that will be sent the keys
	 */
	public KeyboardHandler(Session session) {
		this.session = session;
		this.screen = session.getScreen();

		String os = System.getProperty("os.name");
		if (os.toLowerCase().indexOf("linux") != -1) {
			System.out.println("using os " + os);
			isLinux = true;
		}

		keyMap = KeyMapper.getKeyMapper(session.getConfiguration().getStringProperty("keymapPath"));

		keyMap.addKeyChangeListener(this);

		// initialize the keybingings of the components InputMap
		initKeyBindings();

	}

	public static KeyboardHandler getKeyboardHandlerInstance(Session session) {

		return new DefaultKeyboardHandler(session);
	}

	abstract void initKeyBindings();

	protected InputMap getInputMap() {

		return session.getInputMap();
	}

	protected ActionMap getActionMap() {

		return session.getActionMap();
	}

	public void onKeyChanged() {

		getInputMap().clear();
		getActionMap().clear();
		initKeyBindings();

	}

	public abstract boolean isKeyStrokeDefined(String accelKey);
	public abstract KeyStroke getKeyStroke(String accelKey);

	public String getRecordBuffer() {
		return recordBuffer.toString();
	}

	public void startRecording() {

		recording = true;
		recordBuffer = new StringBuffer();

	}

	public void record(String d) {

		if (recording) {
			recordBuffer.append(d);
		}
	}

	public void stopRecording() {

		recording = false;
		recordBuffer = null;
	}

	public boolean isRecording() {

		return recording;
	}
	protected tnvt getVT() {
		return session.getVT();
	}

	public boolean emulatorAction(KeyStroke ks, KeyEvent e) {
/*
		int kc = ks.getKeyCode();
		switch (kc) {
			case KeyEvent.VK_TAB :
			case KeyEvent.VK_UP :
			case KeyEvent.VK_DOWN :
			case KeyEvent.VK_RIGHT :
			case KeyEvent.VK_LEFT :
			case KeyEvent.VK_DELETE :
			case KeyEvent.VK_ENTER :
			case KeyEvent.VK_PAGE_DOWN :
			case KeyEvent.VK_PAGE_UP :
			case KeyEvent.VK_END :
			case KeyEvent.VK_HOME :
				return false;
		}
*/
		InputMap map = getInputMap();
		ActionMap am = getActionMap();

		if (map != null && am != null && session.isEnabled()) {
			Object binding = map.get(ks);
			Action action = (binding == null) ? null : am.get(binding);
			if (action != null) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Utility method, calls one of <code>keyPressed()</code>,
	 * <code>keyReleased()</code>, or <code>keyTyped()</code>.
	 */
	public void processKeyEvent(KeyEvent evt) {
		switch (evt.getID()) {
			case KeyEvent.KEY_TYPED :
				keyTyped(evt);
				break;
			case KeyEvent.KEY_PRESSED :
				keyPressed(evt);
				break;
			case KeyEvent.KEY_RELEASED :
				keyReleased(evt);
				break;
		}
	}

	// JUN/2006
	public KeyMapper getKeyMapper() {
		return (keyMap);
	}

	// JUN/2006
	public void changeKeyMapper(String nnm) {
		keyMap.removeKeyChangeListener(this);
		keyMap = KeyMapper.getKeyMapper(nnm);
		keyMap.addKeyChangeListener(this);
		initKeyBindings();
	}

}
