package je.tn5250j;

import java.util.*;
import javax.swing.*;
import javax.swing.plaf.basic.BasicArrowButton;

import java.awt.*;
import java.awt.event.*;
import je.tn5250j.interfaces.*;
import je.tn5250j.tools.*;
import je.tn5250j.keyboard.configure.KeyConfigure;

/**
 * @author user
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class MyToolBar extends JPanel implements ActionListener,TN5250jConstants {

//	private GUIViewInterface frame;
	private Container frame;
	private boolean viewsw= true;
	private JButton left,right;
	private int viewmax;
	private boolean applet= false;
	
	private Dimension sepSize = new Dimension(8, 0);

	/**
	 * Constructor for MyToolBar.
	 */
//	public MyToolBar(GUIViewInterface f) {
	public MyToolBar(Container f) {
		super();
		frame= f;
		if (frame instanceof Session) {
			applet= true;
		}

		setLayout(new BorderLayout());
		final JViewport vp= new JViewport();
		final JToolBar toolbar= new JToolBar();
		// add pei 070228 ToolBarŒ
		toolbar.setFloatable(false);
		
		vp.setView(toolbar);
	    JButton button;
		OptionAccessFactory oaf= OptionAccessFactory.getInstance();
		
		if (oaf.isValidOption(MNEMONIC_COPY)) {
	    	button = makeNavigationButton("copy.gif", MNEMONIC_COPY,
	                                  LangTool.getString("popup.copy"));
			toolbar.add(button);
		}

		if (oaf.isValidOption(MNEMONIC_PASTE)) {
	    	button = makeNavigationButton("paste.gif", MNEMONIC_PASTE,
	                                  LangTool.getString("popup.paste"));
			toolbar.add(button);
		}
		
		// Zp[^ǉ pei 060720
		if (oaf.isValidOption(MNEMONIC_COPY) || oaf.isValidOption(MNEMONIC_PASTE))
			toolbar.addSeparator(sepSize);
		
		if (oaf.isValidOption(MNEMONIC_PRINT_SCREEN)) {
	    	button = makeNavigationButton("print.gif", MNEMONIC_PRINT_SCREEN,
	                                  LangTool.getString("popup.printScreen"));
			toolbar.add(button);
			// Zp[^ǉ pei 060720
			toolbar.addSeparator(sepSize);
		}

		if (oaf.isValidOption(MNEMONIC_KEYMAP)) {
	    	button = makeNavigationButton("mapKeys.gif", MNEMONIC_KEYMAP,
	                                  LangTool.getString("popup.mapKeys"));
			toolbar.add(button);
		}

		if (oaf.isValidOption(MNEMONIC_DISP_ATTRIBUTES)) {
	    	button = makeNavigationButton("settings.gif", MNEMONIC_DISP_ATTRIBUTES,
	                                  LangTool.getString("popup.settings"));
			toolbar.add(button);
		}
		
		// Zp[^ǉ pei 060720
		if (oaf.isValidOption(MNEMONIC_KEYMAP) || oaf.isValidOption(MNEMONIC_DISP_ATTRIBUTES)) 
			toolbar.addSeparator(sepSize);

		if (oaf.isValidOption(MNEMONIC_FILE_TRANSFER)) {
	    	button = makeNavigationButton("xtfrFile.gif", MNEMONIC_FILE_TRANSFER,
							LangTool.getString("popup.export") + ":" + LangTool.getString("popup.xtfrFile"));
			toolbar.add(button);
			toolbar.addSeparator(sepSize);
		}
		
		if (!applet) {
			if (oaf.isValidOption(MNEMONIC_OPEN_NEW)) {
		    	button = makeNavigationButton("connections.gif", MNEMONIC_OPEN_NEW,
		                                  LangTool.getString("popup.connections"));
				toolbar.add(button);
				// Zp[^ǉ pei 060720
				toolbar.addSeparator(sepSize);
			}
			
			if (oaf.isValidOption(MNEMONIC_MHELP)) {
		    	button = makeNavigationButton("mhelp.gif", MNEMONIC_MHELP,
		                                  LangTool.getString("popup.mhelp"));
				toolbar.add(button);
				// Zp[^ǉ pei 060720
				toolbar.addSeparator(sepSize);
			}
/*
			if (oaf.isValidOption(MNEMONIC_TOGGLE_CONNECTION)) {
		    	button = makeNavigationButton("connect.gif", MNEMONIC_TOGGLE_CONNECTION,
		                                  LangTool.getString("popup.connect") + "/" + LangTool.getString("popup.disconnect"));
		    	add(button);
			}
*/
			if (oaf.isValidOption(MNEMONIC_CLOSE)) {
		    	button = makeNavigationButton("close.gif", MNEMONIC_CLOSE,
		                                  LangTool.getString("popup.close"));
				toolbar.add(button);
			}
		}
		toolbar.addSeparator();

		if (oaf.isValidOption(MNEMONIC_MACRO)) {
			Vector mv= new Vector();
			Macronizer.init();
			String[] macrosList = Macronizer.getMacroList();

			for (int x = 0; x < macrosList.length; x++) {
				mv.add(macrosList[x]);
			}

			Collections.sort(mv);
			int mcnt= mv.size();

// add start pei 061115 c[o[Ƀ}N{^̕\L
			Properties props =
				ConfigureFactory.getInstance().getProperties(
				GlobalConfigure.SESSIONS);
			if (!props.containsKey("emul.showMacro")) {

//				if (mcnt > 9) mcnt= 9;	// MAX 9 ?
				for (int x = 0; x < mcnt; x++) {
					String mname= (String)mv.elementAt(x);
		    		button = makeMacroButton(mname);
					toolbar.add(button);
				}
			}
// add end
		}

		addComponentListener(new ComponentListener() {
			public void componentResized(ComponentEvent arg0) {
				final Component win= arg0.getComponent();
				Runnable erp = new Runnable() {
					public void run() {
						if (win.getSize().getWidth() < toolbar.getSize().getWidth()) {
							if (!viewsw) {
								add(left, BorderLayout.WEST);
								add(right, BorderLayout.EAST);
								viewsw= true;
								validate();
							}
						} else if (viewsw) {
							remove(left);
							remove(right);
							viewsw= false;
							validate();
						}
						win.repaint();
						viewmax= (int)toolbar.getBounds().getWidth() - (int)vp.getExtentSize().getWidth();
					}
				};
				SwingUtilities.invokeLater(erp);
			}
			public void componentShown(ComponentEvent arg0) {
			}
			public void componentMoved(ComponentEvent arg0) {
			}
			public void componentHidden(ComponentEvent arg0) {
			}
		});
		left=new BasicArrowButton(BasicArrowButton.WEST);
		left.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent actionevent) {
				Point point= vp.getViewPosition();
				int x= (int)point.getX() - 20;
				if (x < 0) x= 0;
				point.setLocation(x, point.getY());
				vp.setViewPosition(point);
				repaint();
			}
		});
		right=new BasicArrowButton(BasicArrowButton.EAST);
		right.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent actionevent) {
				Point point= vp.getViewPosition();
				int x= (int)point.getX() + 20;
				if (x > viewmax) x= viewmax;
				point.setLocation(x, point.getY());
				vp.setViewPosition(point);
				repaint();
			}
		});
		add(left, BorderLayout.WEST);	
		add(right, BorderLayout.EAST);	
		add(vp, BorderLayout.CENTER);
	}

	protected JButton makeNavigationButton(String imageName,
                                       String actionCommand,
                                       String toolTipText) {
	    //Create and initialize the button.
	    JButton button = new JButton();
	    button.setActionCommand(actionCommand);
	    button.setToolTipText(toolTipText);
	    button.addActionListener(this);
	
	    button.setIcon(GUIGraphicsUtils.createImageIcon(imageName));
	
	    return button;
	}

	protected JButton makeMacroButton(String nm) {
	    //Create and initialize the button.
	    JButton button = new JButton();
	    button.setActionCommand(MNEMONIC_MACRO + nm);
	    button.setToolTipText(nm);
	    button.addActionListener(this);
	
	    button.setText(nm.length() > 8 ? nm.substring(0, 8) + ".." : nm);
	
	    return button;
	}

	public void actionPerformed(ActionEvent actionevent) {
		String cmd= actionevent.getActionCommand();
		final Session session;
		if (applet) {
			session= (Session)frame;
		} else {
			session= ((GUIViewInterface)frame).getSelectedSession();
		}
		if (cmd.equals(MNEMONIC_COPY)) {
			session.getScreen().copyMe();
			session.getFocusForMe();
		} else if (cmd.equals(MNEMONIC_PASTE)) {
			session.getScreen().sendKeys(MNEMONIC_PASTE);
			session.getFocusForMe();
		} else if (cmd.equals(MNEMONIC_PRINT_SCREEN)) {
			session.getScreen().printMe();
			session.getFocusForMe();
		} else if (cmd.equals(MNEMONIC_KEYMAP)) {
			SubCommand.mapMeKeys(session);
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
	
					session.getFocusForMe();
				}
			});
//			session.getFocusForMe();
		} else if (cmd.equals(MNEMONIC_DISP_ATTRIBUTES)) {
			session.doAttributes();
			session.getFocusForMe();
		} else if (cmd.equals(MNEMONIC_FILE_TRANSFER)) {
			SubCommand.doTransfer(session);
		} else if (cmd.equals(MNEMONIC_OPEN_NEW)) {
			session.startNewSession();
			session.getFocusForMe();
		} else if (cmd.equals(MNEMONIC_MHELP)) {
			SubCommand.doMHelp();
		} else if (cmd.equals(MNEMONIC_TOGGLE_CONNECTION)) {
			SubCommand.changeConnection(session);
		} else if (cmd.equals(MNEMONIC_CLOSE)) {
			session.closeSession();
		} else if (cmd.startsWith(MNEMONIC_MACRO)) {
			session.executeMeMacro(cmd.substring(MNEMONIC_MACRO.length()));
			session.getFocusForMe();
		}
	}

}
