/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.SubsetType2SubsetRelationship;
import jp.sourceforge.tmdmaker.model.parts.ModelName;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;

public class SubsetEntity
extends AbstractEntityModel {
    private ReusedIdentifier originalReusedIdentifier;

    protected SubsetEntity() {
    }

    protected static SubsetEntity build(AbstractEntityModel parent, ModelName subsetName) {
        SubsetEntity subsetEntity = new SubsetEntity();
        subsetEntity.setName(subsetName.getValue());
        subsetEntity.setOriginalReusedIdentifier(parent.createReusedIdentifier());
        subsetEntity.setEntityType(parent.getEntityType());
        ImplementRule.setModelDefaultValue(subsetEntity);
        return subsetEntity;
    }

    public ReusedIdentifier getOriginalReusedIdentifier() {
        return this.originalReusedIdentifier;
    }

    public void setOriginalReusedIdentifier(ReusedIdentifier originalReusedIdentifier) {
        this.originalReusedIdentifier = originalReusedIdentifier;
    }

    @Override
    public ReusedIdentifier createReusedIdentifier() {
        ReusedIdentifier returnValue = new ReusedIdentifier(this.keyModels.getSurrogateKey());
        returnValue.addAll(this.originalReusedIdentifier.getIdentifiers());
        return returnValue;
    }

    @Override
    public boolean isEntityTypeEditable() {
        return false;
    }

    @Override
    public boolean isDeletable() {
        return this.getModelTargetConnections().size() == 1 && this.getModelSourceConnections().size() == 0;
    }

    public boolean isSupersetAnEntity() {
        return this.originalReusedIdentifier.getIdentifiers().size() == 1;
    }

    public boolean isSameSubset() {
        SubsetType type = this.getSubsetType();
        if (type == null) {
            return false;
        }
        return type.getSubsetType().equals((Object)SubsetType.SubsetTypeValue.SAME);
    }

    private SubsetType getSubsetType() {
        if (this.getModelTargetConnections().size() == 0) {
            return null;
        }
        SubsetType2SubsetRelationship r = this.getSubsetTypeRelationship();
        if (r != null) {
            return (SubsetType)r.getSource();
        }
        return null;
    }

    public SubsetType2SubsetRelationship getSubsetTypeRelationship() {
        return (SubsetType2SubsetRelationship)this.getModelTargetConnections().get(0);
    }

    @Override
    public SubsetEntity getCopy() {
        SubsetEntity copy = new SubsetEntity();
        this.copyTo(copy);
        return copy;
    }

    public AbstractEntityModel getSuperset() {
        SubsetType type = this.getSubsetTypeRelationship().getSubsetType();
        return type.getSuperset();
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean hasRelationship() {
        return this.getModelSourceConnections().size() != 0 || this.getModelTargetConnections().size() > 1;
    }
}

