/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static final String CF_UNICODETEXT = "CF_UNICODETEXT";
    private static final String CF_TEXT = "CF_TEXT";
    private static final int CF_UNICODETEXTID = 13;
    private static final int CF_TEXTID = 1;

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -2147467259;
        String string = (String)object;
        switch (transferData.type) {
            case 13: {
                int charCount = string.length();
                char[] chars = new char[charCount + 1];
                string.getChars(0, charCount, chars, 0);
                int byteCount = chars.length * 2;
                long newPtr = OS.GlobalAlloc(64, byteCount);
                OS.MoveMemory(newPtr, chars, byteCount);
                transferData.stgmedium = new STGMEDIUM();
                transferData.stgmedium.tymed = 1;
                transferData.stgmedium.unionField = newPtr;
                transferData.stgmedium.pUnkForRelease = 0L;
                transferData.result = 0;
                break;
            }
            case 1: {
                int count = string.length();
                char[] chars = new char[count + 1];
                string.getChars(0, count, chars, 0);
                int codePage = OS.GetACP();
                int cchMultiByte = OS.WideCharToMultiByte(codePage, 0, chars, -1, null, 0, null, null);
                if (cchMultiByte == 0) {
                    transferData.stgmedium = new STGMEDIUM();
                    transferData.result = -2147221402;
                    return;
                }
                long lpMultiByteStr = OS.GlobalAlloc(64, cchMultiByte);
                OS.WideCharToMultiByte(codePage, 0, chars, -1, lpMultiByteStr, cchMultiByte, null, null);
                transferData.stgmedium = new STGMEDIUM();
                transferData.stgmedium.tymed = 1;
                transferData.stgmedium.unionField = lpMultiByteStr;
                transferData.stgmedium.pUnkForRelease = 0L;
                transferData.result = 0;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        block27: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    if (this.isSupportedType(transferData) == false) return null;
                                    if (transferData.pIDataObject == 0L) {
                                        return null;
                                    }
                                    data = new IDataObject(transferData.pIDataObject);
                                    data.AddRef();
                                    formatetc = transferData.formatetc;
                                    stgmedium = new STGMEDIUM();
                                    stgmedium.tymed = 1;
                                    transferData.result = this.getData(data, formatetc, stgmedium);
                                    data.Release();
                                    if (transferData.result != 0) {
                                        return null;
                                    }
                                    hMem = stgmedium.unionField;
                                    try {
                                        switch (transferData.type) {
                                            case 13: {
                                                size = OS.GlobalSize(hMem) / 2 * 2;
                                                if (size == 0) {
                                                    var8_8 = null;
                                                    var18_10 = null;
                                                    break block21;
                                                }
                                                chars = new char[size / 2];
                                                ptr = OS.GlobalLock(hMem);
                                                if (ptr == 0L) {
                                                    var11_21 = null;
                                                    break block22;
                                                }
                                                try {
                                                    OS.MoveMemory(chars, ptr, size);
                                                    length = chars.length;
                                                    for (i = 0; i < chars.length; ++i) {
                                                        if (chars[i] != '\u0000') continue;
                                                        length = i;
                                                        break;
                                                    }
                                                    var12_26 = new String(chars, 0, length);
                                                    var14_28 = null;
                                                }
                                                catch (Throwable var13_30) {
                                                    var14_29 = null;
                                                    OS.GlobalUnlock(hMem);
                                                    throw var13_30;
                                                }
                                                OS.GlobalUnlock(hMem);
                                                break block23;
                                            }
                                            case 1: {
                                                lpMultiByteStr = OS.GlobalLock(hMem);
                                                if (lpMultiByteStr == 0L) {
                                                    ptr = null;
                                                    break block24;
                                                }
                                                try {
                                                    codePage = OS.GetACP();
                                                    cchWideChar = OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, null, 0);
                                                    if (cchWideChar == 0) {
                                                        length = null;
                                                        var16_32 = null;
                                                    }
                                                    ** GOTO lbl-1000
                                                }
                                                catch (Throwable var15_35) {
                                                    var16_34 = null;
                                                    OS.GlobalUnlock(hMem);
                                                    throw var15_35;
                                                }
                                                OS.GlobalUnlock(hMem);
                                                break block25;
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                lpWideCharStr = new char[cchWideChar - 1];
                                                OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, lpWideCharStr, lpWideCharStr.length);
                                                var12_27 = new String(lpWideCharStr);
                                                var16_33 = null;
                                            }
                                            OS.GlobalUnlock(hMem);
                                            break block26;
                                            default: {
                                                break;
                                            }
                                        }
                                        break block27;
                                    }
                                    catch (Throwable var17_36) {
                                        var18_17 = null;
                                        OS.GlobalFree(hMem);
                                        throw var17_36;
                                    }
                                }
                                OS.GlobalFree(hMem);
                                return var8_8;
                            }
                            var18_11 = null;
                            OS.GlobalFree(hMem);
                            return var11_21;
                        }
                        var18_12 = null;
                        OS.GlobalFree(hMem);
                        return var12_26;
                    }
                    var18_13 = null;
                    OS.GlobalFree(hMem);
                    return ptr;
                }
                var18_14 = null;
                OS.GlobalFree(hMem);
                return length;
            }
            var18_15 = null;
            OS.GlobalFree(hMem);
            return var12_27;
        }
        var18_16 = null;
        OS.GlobalFree(hMem);
        return null;
    }

    protected int[] getTypeIds() {
        return new int[]{13, 1};
    }

    protected String[] getTypeNames() {
        return new String[]{CF_UNICODETEXT, CF_TEXT};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

