/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate.relationshiplist;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.generate.Activator;
import jp.sourceforge.tmdmaker.generate.Generator;
import jp.sourceforge.tmdmaker.generate.GeneratorRuntimeException;
import jp.sourceforge.tmdmaker.generate.HtmlGeneratorUtils;
import jp.sourceforge.tmdmaker.generate.relationshiplist.RelationshipMapping;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipListHtmlGenerator
implements Generator {
    private static Logger logger = LoggerFactory.getLogger(RelationshipListHtmlGenerator.class);

    public String getGeneratorName() {
        return "\u95a2\u4fc2\u306e\u691c\u8a3c\u8868\u3092HTML\u5f62\u5f0f\u3067\u51fa\u529b";
    }

    public String getGroupName() {
        return "HTML";
    }

    public void execute(String rootDir, List<AbstractEntityModel> models) {
        logger.info("generate");
        VelocityContext context = HtmlGeneratorUtils.getVecityContext();
        Map<AbstractEntityModel, List<RelationshipMapping>> relationshipMappingMap = this.createData(models);
        context.put("entities", relationshipMappingMap.keySet());
        context.put("mappings", relationshipMappingMap.entrySet());
        try {
            HtmlGeneratorUtils.outputCSS(rootDir);
            HtmlGeneratorUtils.applyTemplate("relationship_list.html", this.getClass(), new File(rootDir, "relationship_list.html"), context);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new GeneratorRuntimeException((Throwable)e);
        }
        try {
            HtmlGeneratorUtils.copyStream(Activator.class.getResourceAsStream("stylesheet.css"), new FileOutputStream(new File(rootDir, "stylesheet.css")));
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
            throw new GeneratorRuntimeException((Throwable)e);
        }
    }

    private Map<AbstractEntityModel, List<RelationshipMapping>> createData(List<AbstractEntityModel> models) {
        LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>> relationshipMappingMap = new LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>>();
        for (AbstractEntityModel source : models) {
            ArrayList<RelationshipMapping> relationshipMappingList = new ArrayList<RelationshipMapping>();
            for (AbstractEntityModel target : models) {
                relationshipMappingList.add(new RelationshipMapping(source, target));
            }
            relationshipMappingMap.put(source, relationshipMappingList);
        }
        return relationshipMappingMap;
    }

    public boolean isImplementModelOnly() {
        return false;
    }
}

