/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.Policy;
import org.eclipse.ui.internal.navigator.VisibilityAssistant;
import org.eclipse.ui.internal.navigator.extensions.EvalutationReference;
import org.eclipse.ui.internal.navigator.extensions.ExtensionSequenceNumberComparator;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.navigator.OverridePolicy;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NavigatorContentDescriptorManager {
    private static final NavigatorContentDescriptorManager INSTANCE = new NavigatorContentDescriptorManager();
    private final Map firstClassDescriptorsMap = new HashMap();
    private final Map allDescriptors = new HashMap();
    private final Map cachedTriggerPointEvaluations = new WeakHashMap();
    private final Map cachedPossibleChildrenEvaluations = new WeakHashMap();
    private ImageRegistry imageRegistry;
    private final Set overridingDescriptors = new HashSet();
    private final Set saveablesProviderDescriptors = new HashSet();
    private final Set sortOnlyDescriptors = new HashSet();
    private final Set firstClassDescriptorsSet = new HashSet();
    private static final boolean POSSIBLE_CHILD = true;

    public static NavigatorContentDescriptorManager getInstance() {
        return INSTANCE;
    }

    private NavigatorContentDescriptorManager() {
        new NavigatorContentDescriptorRegistry().readRegistry();
    }

    public NavigatorContentDescriptor[] getAllContentDescriptors() {
        NavigatorContentDescriptor[] finalDescriptors = new NavigatorContentDescriptor[this.allDescriptors.size()];
        finalDescriptors = this.allDescriptors.values().toArray(finalDescriptors);
        Arrays.sort(finalDescriptors, ExtensionSequenceNumberComparator.INSTANCE);
        return finalDescriptors;
    }

    public NavigatorContentDescriptor[] getContentDescriptorsWithSaveables() {
        NavigatorContentDescriptor[] finalDescriptors = new NavigatorContentDescriptor[this.saveablesProviderDescriptors.size()];
        this.saveablesProviderDescriptors.toArray(finalDescriptors);
        Arrays.sort(finalDescriptors, ExtensionSequenceNumberComparator.INSTANCE);
        return finalDescriptors;
    }

    public NavigatorContentDescriptor[] getSortOnlyContentDescriptors() {
        NavigatorContentDescriptor[] finalDescriptors = new NavigatorContentDescriptor[this.sortOnlyDescriptors.size()];
        this.sortOnlyDescriptors.toArray(finalDescriptors);
        Arrays.sort(finalDescriptors, ExtensionSequenceNumberComparator.INSTANCE);
        return finalDescriptors;
    }

    public Set findDescriptorsForTriggerPoint(Object anElement, VisibilityAssistant aVisibilityAssistant, boolean considerOverrides) {
        return this.findDescriptors(anElement, this.cachedTriggerPointEvaluations, aVisibilityAssistant, considerOverrides, false);
    }

    public Set findDescriptorsForPossibleChild(Object anElement, VisibilityAssistant aVisibilityAssistant, boolean toComputeOverrides) {
        return this.findDescriptors(anElement, this.cachedPossibleChildrenEvaluations, aVisibilityAssistant, toComputeOverrides, true);
    }

    private Set findDescriptors(Object anElement, Map cachedEvaluations, VisibilityAssistant aVisibilityAssistant, boolean considerOverrides, boolean possibleChild) {
        EvaluationCache cache = this.getEvaluationCache(cachedEvaluations, aVisibilityAssistant);
        TreeSet<NavigatorContentDescriptor> descriptors = new TreeSet<NavigatorContentDescriptor>(ExtensionSequenceNumberComparator.INSTANCE);
        NavigatorContentDescriptor[] cachedDescriptors = null;
        cachedDescriptors = cache.getDescriptors(anElement);
        if (cachedDescriptors != null) {
            descriptors.addAll(Arrays.asList(cachedDescriptors));
        }
        if (considerOverrides) {
            this.addDescriptorsConsideringOverrides(anElement, this.firstClassDescriptorsSet, aVisibilityAssistant, descriptors, possibleChild);
            if (Policy.DEBUG_RESOLUTION) {
                System.out.println("Find descriptors for: " + Policy.getObjectString(anElement) + ": " + descriptors);
            }
        } else {
            Iterator contentDescriptorsItr = this.firstClassDescriptorsSet.iterator();
            while (contentDescriptorsItr.hasNext()) {
                NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)contentDescriptorsItr.next();
                if (!aVisibilityAssistant.isActive(descriptor) || !aVisibilityAssistant.isVisible(descriptor) || !(possibleChild ? descriptor.isPossibleChild(anElement) : descriptor.isTriggerPoint(anElement))) continue;
                descriptors.add(descriptor);
            }
        }
        cache.setDescriptors(anElement, descriptors.toArray(new NavigatorContentDescriptor[descriptors.size()]));
        return descriptors;
    }

    private EvaluationCache getEvaluationCache(Map anEvaluationMap, VisibilityAssistant aVisibilityAssistant) {
        EvaluationCache c = (EvaluationCache)anEvaluationMap.get(aVisibilityAssistant);
        if (c == null) {
            c = new EvaluationCache(aVisibilityAssistant);
            anEvaluationMap.put(aVisibilityAssistant, c);
        }
        return c;
    }

    private boolean addDescriptorsConsideringOverrides(Object anElement, Set theChildDescriptors, VisibilityAssistant aVisibilityAssistant, Set theFoundDescriptors, boolean possibleChild) {
        int initialSize = theFoundDescriptors.size();
        Iterator contentDescriptorsItr = theChildDescriptors.iterator();
        while (contentDescriptorsItr.hasNext()) {
            boolean isApplicable;
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)contentDescriptorsItr.next();
            boolean bl = aVisibilityAssistant.isActive(descriptor) && aVisibilityAssistant.isVisible(descriptor) && (possibleChild ? descriptor.isPossibleChild(anElement) : descriptor.isTriggerPoint(anElement)) ? true : (isApplicable = false);
            if (descriptor.hasOverridingExtensions()) {
                TreeSet overridingDescriptors = new TreeSet(ExtensionSequenceNumberComparator.INSTANCE);
                boolean isOverridden = this.addDescriptorsConsideringOverrides(anElement, descriptor.getOverriddingExtensions(), aVisibilityAssistant, overridingDescriptors, possibleChild);
                if (!isOverridden && isApplicable) {
                    theFoundDescriptors.add(descriptor);
                    continue;
                }
                if (!isOverridden) continue;
                theFoundDescriptors.addAll(overridingDescriptors);
                continue;
            }
            if (!isApplicable) continue;
            theFoundDescriptors.add(descriptor);
        }
        return initialSize < theFoundDescriptors.size();
    }

    public NavigatorContentDescriptor getContentDescriptor(String id) {
        return (NavigatorContentDescriptor)this.allDescriptors.get(id);
    }

    public String getText(String descriptorId) {
        NavigatorContentDescriptor descriptor = this.getContentDescriptor(descriptorId);
        if (descriptor != null) {
            return descriptor.getName();
        }
        return descriptorId;
    }

    public Image getImage(String descriptorId) {
        return this.retrieveAndStoreImage(descriptorId);
    }

    protected Image retrieveAndStoreImage(String descriptorId) {
        ImageDescriptor imageDescriptor;
        String icon;
        NavigatorContentDescriptor contentDescriptor = this.getContentDescriptor(descriptorId);
        Image image = null;
        if (contentDescriptor != null && (icon = contentDescriptor.getIcon()) != null && ((image = this.getImageRegistry().get(icon)) == null || image.isDisposed()) && (imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)contentDescriptor.getContribution().getPluginId(), (String)icon)) != null && (image = imageDescriptor.createImage()) != null) {
            this.getImageRegistry().put(icon, image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNavigatorContentDescriptor(NavigatorContentDescriptor desc) {
        if (desc == null) {
            return;
        }
        Map map = this.firstClassDescriptorsMap;
        synchronized (map) {
            if (this.firstClassDescriptorsMap.containsKey(desc.getId())) {
                NavigatorPlugin.logError(0, "An extension already exists with id \"" + desc.getId() + "\".", null);
            } else {
                if (desc.getSuppressedExtensionId() == null) {
                    this.firstClassDescriptorsMap.put(desc.getId(), desc);
                    this.firstClassDescriptorsSet.add(desc);
                    if (Policy.DEBUG_EXTENSION_SETUP) {
                        System.out.println("First class descriptor: " + desc);
                    }
                } else {
                    this.overridingDescriptors.add(desc);
                    if (Policy.DEBUG_EXTENSION_SETUP) {
                        System.out.println("Overriding descriptor: " + desc);
                    }
                }
                this.allDescriptors.put(desc.getId(), desc);
                if (desc.hasSaveablesProvider()) {
                    this.saveablesProviderDescriptors.add(desc);
                    if (Policy.DEBUG_EXTENSION_SETUP) {
                        System.out.println("Saveables provider descriptor: " + desc);
                    }
                }
                if (desc.isSortOnly()) {
                    this.sortOnlyDescriptors.add(desc);
                    if (Policy.DEBUG_EXTENSION_SETUP) {
                        System.out.println("SortOnly descriptor: " + desc);
                    }
                }
            }
        }
    }

    private void computeOverrides() {
        if (this.overridingDescriptors.size() > 0) {
            Iterator overridingIterator = this.overridingDescriptors.iterator();
            while (overridingIterator.hasNext()) {
                NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)overridingIterator.next();
                NavigatorContentDescriptor overriddenDescriptor = (NavigatorContentDescriptor)this.allDescriptors.get(descriptor.getSuppressedExtensionId());
                if (overriddenDescriptor != null) {
                    if (Policy.DEBUG_EXTENSION_SETUP) {
                        System.out.println(descriptor + " overrides: " + overriddenDescriptor);
                    }
                    overriddenDescriptor.getOverriddingExtensions().add(descriptor);
                    descriptor.setOverriddenDescriptor(overriddenDescriptor);
                    if (descriptor.getOverridePolicy() != OverridePolicy.InvokeAlwaysRegardlessOfSuppressedExt) continue;
                    if (Policy.DEBUG_EXTENSION_SETUP) {
                        System.out.println(descriptor + " is first class");
                    }
                    this.firstClassDescriptorsMap.put(descriptor.getId(), descriptor);
                    this.firstClassDescriptorsSet.add(descriptor);
                    continue;
                }
                String message = "Invalid suppressedExtensionId \"" + descriptor.getSuppressedExtensionId() + "\" specified from \"" + descriptor.getId() + "\" in \"" + descriptor.getContribution().getPluginId() + "\". No extension with matching id found.";
                if (Policy.DEBUG_EXTENSION_SETUP) {
                    System.out.println("Error: " + message);
                }
                NavigatorPlugin.logError(0, message, null);
            }
        }
    }

    private int findId(List list, String id) {
        int i = 0;
        int len = list.size();
        while (i < len) {
            NavigatorContentDescriptor desc = (NavigatorContentDescriptor)list.get(i);
            if (desc.getId().equals(id)) {
                return i;
            }
            ++i;
        }
        NavigatorPlugin.log(2, 0, "Can't find Navigator Content Descriptor with id: " + id, null);
        return -1;
    }

    private void computeSequenceNumbers() {
        NavigatorContentDescriptor desc;
        int len;
        int i;
        NavigatorContentDescriptor[] descs = this.getAllContentDescriptors();
        LinkedList<NavigatorContentDescriptor> list = new LinkedList<NavigatorContentDescriptor>();
        int i2 = 0;
        while (i2 < descs.length) {
            list.add(descs[i2]);
            ++i2;
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            i = 0;
            len = list.size();
            while (i < len) {
                int beforeInd;
                desc = (NavigatorContentDescriptor)list.get(i);
                if (desc.getAppearsBeforeId() != null && (beforeInd = this.findId(list, desc.getAppearsBeforeId())) >= 0 && beforeInd < i) {
                    list.add(beforeInd, desc);
                    list.remove(i + 1);
                    changed = true;
                }
                ++i;
            }
        }
        i = 0;
        len = list.size();
        while (i < len) {
            desc = (NavigatorContentDescriptor)list.get(i);
            desc.setSequenceNumber(i);
            if (Policy.DEBUG_EXTENSION_SETUP) {
                System.out.println("Descriptors by sequence: " + desc);
            }
            ++i;
        }
    }

    private ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry();
        }
        return this.imageRegistry;
    }

    static /* synthetic */ void access$2(NavigatorContentDescriptorManager navigatorContentDescriptorManager, NavigatorContentDescriptor navigatorContentDescriptor) {
        navigatorContentDescriptorManager.addNavigatorContentDescriptor(navigatorContentDescriptor);
    }

    private class EvaluationCache
    implements VisibilityAssistant.VisibilityListener {
        private final Map evaluations = new HashMap();
        private final Map evaluationsWithOverrides = new HashMap();

        EvaluationCache(VisibilityAssistant anAssistant) {
            anAssistant.addListener(this);
        }

        protected final NavigatorContentDescriptor[] getDescriptors(Object anElement) {
            return this.getDescriptors(anElement, true);
        }

        protected final void setDescriptors(Object anElement, NavigatorContentDescriptor[] theDescriptors) {
            this.setDescriptors(anElement, theDescriptors, true);
        }

        protected final NavigatorContentDescriptor[] getDescriptors(Object anElement, boolean toComputeOverrides) {
            if (anElement == null) {
                return null;
            }
            NavigatorContentDescriptor[] cachedDescriptors = null;
            if (toComputeOverrides) {
                SoftReference cache = (SoftReference)this.evaluations.get(anElement);
                if (cache != null && (cachedDescriptors = (NavigatorContentDescriptor[])cache.get()) == null) {
                    this.evaluations.remove(anElement);
                }
                return cachedDescriptors;
            }
            SoftReference cache = (SoftReference)this.evaluationsWithOverrides.get(anElement);
            if (cache != null && (cachedDescriptors = (NavigatorContentDescriptor[])cache.get()) == null) {
                this.evaluationsWithOverrides.remove(anElement);
            }
            return cachedDescriptors;
        }

        protected final void setDescriptors(Object anElement, NavigatorContentDescriptor[] theDescriptors, boolean toComputeOverrides) {
            if (anElement != null) {
                if (toComputeOverrides) {
                    this.evaluations.put(new EvalutationReference(anElement), new SoftReference<NavigatorContentDescriptor[]>(theDescriptors));
                } else {
                    this.evaluationsWithOverrides.put(new EvalutationReference(anElement), new SoftReference<NavigatorContentDescriptor[]>(theDescriptors));
                }
            }
        }

        public void onVisibilityOrActivationChange() {
            this.evaluations.clear();
            this.evaluationsWithOverrides.clear();
        }
    }

    private class NavigatorContentDescriptorRegistry
    extends NavigatorContentRegistryReader {
        private NavigatorContentDescriptorRegistry() {
        }

        public void readRegistry() {
            super.readRegistry();
            NavigatorContentDescriptorManager.this.computeSequenceNumbers();
            NavigatorContentDescriptorManager.this.computeOverrides();
        }

        protected boolean readElement(IConfigurationElement anElement) {
            if ("navigatorContent".equals(anElement.getName())) {
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(this, anElement, anElement){
                    final /* synthetic */ NavigatorContentDescriptorRegistry this$1;
                    private final /* synthetic */ IConfigurationElement val$anElement;
                    {
                        this.this$1 = navigatorContentDescriptorRegistry;
                        this.val$anElement = iConfigurationElement;
                    }

                    public void run() throws Exception {
                        NavigatorContentDescriptorManager.access$2(NavigatorContentDescriptorRegistry.access$1(this.this$1), new NavigatorContentDescriptor(this.val$anElement));
                    }
                });
            }
            return super.readElement(anElement);
        }

        static /* synthetic */ NavigatorContentDescriptorManager access$1(NavigatorContentDescriptorRegistry navigatorContentDescriptorRegistry) {
            return navigatorContentDescriptorRegistry.NavigatorContentDescriptorManager.this;
        }
    }
}

