/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.component.ModelSelectPanel;
import jp.sourceforge.tmdmaker.dialog.component.VirtualSupersetSettingPanel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;
import jp.sourceforge.tmdmaker.model.rule.VirtualEntityRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VirtualSupersetCreateDialog
extends Dialog {
    private VirtualSupersetSettingPanel panel1;
    private ModelSelectPanel panel2;
    private VirtualSuperset superset;
    private VirtualSuperset editedValue;
    private VirtualSupersetType editedAggregator;
    private List<AbstractEntityModel> notSelection;
    private List<AbstractEntityModel> selection;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text t = (Text)e.getSource();
            String name = t.getText();
            Button okButton = VirtualSupersetCreateDialog.this.getButton(0);
            if (okButton != null) {
                okButton.setEnabled(name.length() != 0);
            }
        }
    };

    public VirtualSupersetCreateDialog(Shell parentShell, Diagram diagram, VirtualSuperset superset, List<AbstractEntityModel> selectedList) {
        super(parentShell);
        this.superset = superset;
        this.selection = new ArrayList<AbstractEntityModel>();
        if (this.superset != null) {
            this.selection.addAll(this.superset.getVirtualSubsetList());
        }
        this.selection.addAll(selectedList);
        this.notSelection = new ArrayList<AbstractEntityModel>();
        for (ModelElement m : diagram.getChildren()) {
            if (!(m instanceof AbstractEntityModel) || m.equals(superset) || this.selection.contains(m)) continue;
            this.notSelection.add((AbstractEntityModel)m);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("\u30b9\u30fc\u30d1\u30fc\u30bb\u30c3\u30c8\u7de8\u96c6");
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.panel1 = new VirtualSupersetSettingPanel(composite, 0);
        GridData gridData = new GridData(768);
        this.panel1.setLayoutData(gridData);
        this.panel1.addNameModifyListener(this.listener);
        this.panel2 = new ModelSelectPanel(composite, 0);
        gridData = new GridData(768);
        this.panel2.setLayoutData(gridData);
        this.panel1.initializeValue(this.superset);
        this.panel2.initializeValue(this.selection, this.notSelection);
        return composite;
    }

    protected void okPressed() {
        this.editedValue = VirtualEntityRule.createVirtualSuperset(this.panel1.getVirtualSupersetName());
        this.editedAggregator = new VirtualSupersetType();
        this.editedAggregator.setApplyAttribute(this.panel1.isApplyAttributeSelected());
        super.okPressed();
    }

    public boolean close() {
        this.panel1.removeNameModifyListener(this.listener);
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
    }

    public VirtualSuperset getEditedValue() {
        return this.editedValue;
    }

    public List<AbstractEntityModel> getNotSelection() {
        return this.notSelection;
    }

    public List<AbstractEntityModel> getSelection() {
        return this.selection;
    }

    public VirtualSupersetType getEditedAggregator() {
        return this.editedAggregator;
    }
}

