/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.util.List;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.wizards.datatransfer.WizardArchiveFileResourceExportPage1;
import org.eclipse.ui.wizards.datatransfer.CPOpUtils;
import org.eclipse.ui.wizards.datatransfer.CPZipFileOp;

public class CPZipFileOpTypePage
extends WizardArchiveFileResourceExportPage1 {
    public static final String PAGE_NAME = "CPZipFileOpTypePage";
    private static final String STORE_DESTINATION_NAMES_ID = "WizardZipFileResourceExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_FILE_ID = "WizardZipFileResourceExportPage1.STORE_OVERWRITE_EXISTING_FILE_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "WizardZipFileResourceExportPage1.STORE_CREATE_STRUCTURE_ID";
    private static final String STORE_COMPRESS_CONTENTS_ID = "WizardZipFileResourceExportPage1.STORE_COMPRESS_CONTENTS_ID";
    private final CPZipFileOp _model;
    private Combo _destinationField;

    public CPZipFileOpTypePage(CPZipFileOp model) {
        super((IStructuredSelection)new StructuredSelection(model.getResourcesToExport()));
        this._model = model;
    }

    public CPZipFileOpTypePage(IStructuredSelection selection) {
        super(selection);
        this._model = null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (this._model == null) {
            return settings;
        }
        if (settings == null) {
            settings = new DialogSettings(PAGE_NAME);
        }
        String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
        directoryNames = CPOpUtils.createArrayWithFirst(directoryNames, this._model.getDestinationFilename(), 5);
        settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
        settings.put(STORE_OVERWRITE_EXISTING_FILE_ID, this._model.getOverwriteFile());
        settings.put(STORE_CREATE_STRUCTURE_ID, this._model.getCreateLeadupStructure());
        settings.put(STORE_COMPRESS_CONTENTS_ID, this._model.getUseCompression());
        return settings;
    }

    protected boolean ensureTargetIsValid() {
        return true;
    }

    protected boolean ensureDirectoryExists(File directory) {
        return true;
    }

    protected boolean ensureResourcesLocal(List resources) {
        return true;
    }

    protected String getConflictingContainerNameFor(String targetDirectory) {
        return null;
    }

    public boolean finish() {
        IDialogSettings settings;
        if (!super.finish()) {
            return false;
        }
        CPZipFileOp model = new CPZipFileOp(null, this.getWhiteCheckedResources(), this.getDestinationValue());
        if (this._model != null) {
            model.setUnknownResources(this._model.getUnknownResources());
        }
        if ((settings = super.getDialogSettings()) != null) {
            model.setOverwriteFile(settings.getBoolean(STORE_OVERWRITE_EXISTING_FILE_ID));
        }
        return this.executeExportOperation(model);
    }

    protected void createDestinationGroup(Composite parent) {
        super.createDestinationGroup(parent);
        Control[] children = parent.getChildren();
        Composite destinationSelectionGroup = (Composite)children[children.length - 2];
        children = destinationSelectionGroup.getChildren();
        this._destinationField = (Combo)children[children.length - 2];
    }

    protected String getDestinationValue() {
        String destinationText;
        if (this._destinationField != null && (destinationText = this._destinationField.getText().trim()).endsWith("}")) {
            return destinationText;
        }
        return super.getDestinationValue();
    }
}

