/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static final String CF_UNICODETEXT = "CF_UNICODETEXT";
    private static final String CF_TEXT = "CF_TEXT";
    private static final int CF_UNICODETEXTID = 13;
    private static final int CF_TEXTID = 1;

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -2147467259;
        String string = (String)object;
        switch (transferData.type) {
            case 13: {
                int charCount = string.length();
                char[] chars = new char[charCount + 1];
                string.getChars(0, charCount, chars, 0);
                int byteCount = chars.length * 2;
                int newPtr = OS.GlobalAlloc(64, byteCount);
                OS.MoveMemory(newPtr, chars, byteCount);
                transferData.stgmedium = new STGMEDIUM();
                transferData.stgmedium.tymed = 1;
                transferData.stgmedium.unionField = newPtr;
                transferData.stgmedium.pUnkForRelease = 0;
                transferData.result = 0;
                break;
            }
            case 1: {
                int count = string.length();
                char[] chars = new char[count + 1];
                string.getChars(0, count, chars, 0);
                int codePage = OS.GetACP();
                int cchMultiByte = OS.WideCharToMultiByte(codePage, 0, chars, -1, null, 0, null, null);
                if (cchMultiByte == 0) {
                    transferData.stgmedium = new STGMEDIUM();
                    transferData.result = -2147221402;
                    return;
                }
                int lpMultiByteStr = OS.GlobalAlloc(64, cchMultiByte);
                OS.WideCharToMultiByte(codePage, 0, chars, -1, lpMultiByteStr, cchMultiByte, null, null);
                transferData.stgmedium = new STGMEDIUM();
                transferData.stgmedium.tymed = 1;
                transferData.stgmedium.unionField = lpMultiByteStr;
                transferData.stgmedium.pUnkForRelease = 0;
                transferData.result = 0;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        block27: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    if (this.isSupportedType(transferData) == false) return null;
                                    if (transferData.pIDataObject == 0) {
                                        return null;
                                    }
                                    data = new IDataObject(transferData.pIDataObject);
                                    data.AddRef();
                                    formatetc = transferData.formatetc;
                                    stgmedium = new STGMEDIUM();
                                    stgmedium.tymed = 1;
                                    transferData.result = this.getData(data, formatetc, stgmedium);
                                    data.Release();
                                    if (transferData.result != 0) {
                                        return null;
                                    }
                                    hMem = stgmedium.unionField;
                                    try {
                                        switch (transferData.type) {
                                            case 13: {
                                                size = OS.GlobalSize(hMem) / 2 * 2;
                                                if (size == 0) {
                                                    var7_8 = null;
                                                    var16_12 = null;
                                                    break block21;
                                                }
                                                chars = new char[size / 2];
                                                ptr = OS.GlobalLock(hMem);
                                                if (ptr == 0) {
                                                    var9_22 = null;
                                                    break block22;
                                                }
                                                try {
                                                    OS.MoveMemory(chars, ptr, size);
                                                    length = chars.length;
                                                    for (i = 0; i < chars.length; ++i) {
                                                        if (chars[i] != '\u0000') continue;
                                                        length = i;
                                                        break;
                                                    }
                                                    var10_27 = new String(chars, 0, length);
                                                    var12_29 = null;
                                                }
                                                catch (Throwable var11_31) {
                                                    var12_30 = null;
                                                    OS.GlobalUnlock(hMem);
                                                    throw var11_31;
                                                }
                                                OS.GlobalUnlock(hMem);
                                                break block23;
                                            }
                                            case 1: {
                                                lpMultiByteStr = OS.GlobalLock(hMem);
                                                if (lpMultiByteStr == 0) {
                                                    chars = null;
                                                    break block24;
                                                }
                                                try {
                                                    codePage = OS.GetACP();
                                                    cchWideChar = OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, null, 0);
                                                    if (cchWideChar == 0) {
                                                        length = null;
                                                        var14_32 = null;
                                                    }
                                                    ** GOTO lbl-1000
                                                }
                                                catch (Throwable var13_35) {
                                                    var14_34 = null;
                                                    OS.GlobalUnlock(hMem);
                                                    throw var13_35;
                                                }
                                                OS.GlobalUnlock(hMem);
                                                break block25;
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                lpWideCharStr = new char[cchWideChar - 1];
                                                OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, lpWideCharStr, lpWideCharStr.length);
                                                var10_28 = new String(lpWideCharStr);
                                                var14_33 = null;
                                            }
                                            OS.GlobalUnlock(hMem);
                                            break block26;
                                            default: {
                                                break;
                                            }
                                        }
                                        break block27;
                                    }
                                    catch (Throwable var15_36) {
                                        var16_19 = null;
                                        OS.GlobalFree(hMem);
                                        throw var15_36;
                                    }
                                }
                                OS.GlobalFree(hMem);
                                return var7_8;
                            }
                            var16_13 = null;
                            OS.GlobalFree(hMem);
                            return var9_22;
                        }
                        var16_14 = null;
                        OS.GlobalFree(hMem);
                        return var10_27;
                    }
                    var16_15 = null;
                    OS.GlobalFree(hMem);
                    return chars;
                }
                var16_16 = null;
                OS.GlobalFree(hMem);
                return length;
            }
            var16_17 = null;
            OS.GlobalFree(hMem);
            return var10_28;
        }
        var16_18 = null;
        OS.GlobalFree(hMem);
        return null;
    }

    protected int[] getTypeIds() {
        return new int[]{13, 1};
    }

    protected String[] getTypeNames() {
        return new String[]{CF_UNICODETEXT, CF_TEXT};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

