/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.node;


import jp.sf.tatooine.gtx.GtxContext;
import jp.sf.tatooine.gtx.GtxSyntaxException;

/**
 * DTDNode.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/09/10
 * @since   JDK5.0 Tiger
 */
public class DTDNode extends Node {
	
	private static final String DOCTYPE_PREFIX = "<!DOCTYPE ";
	
	private static final String PUBLIC_DECL_START = " PUBLIC \"";
	
	private static final String SYSTEM_DECL_START1 = " SYSTEM \"";
	
	private static final String SYSTEM_DECL_START2 = "\" \"";
	
	private static final String DECL_END = "\"";

	private String _name;
	
	private String _publicId;
	
	private String _systemId;
	
	public DTDNode(String name, String publicId, String systemId) {
		_name = name;
		_publicId = publicId;
		_systemId = systemId;
	}

	/**
	 * @see jp.sf.tatooine.gtx.node.GtxEvaluateable
	 * 		#evaluate(StringBuilder, jp.sf.tatooine.gtx.GtxContext)
	 */
	public void evaluate(StringBuilder builder, GtxContext context) throws GtxSyntaxException {
		builder.append(toString());
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		
		StringBuilder builder = new StringBuilder();
		builder.append(DOCTYPE_PREFIX);
		builder.append(_name);
		if (_publicId == null) {
			builder.append(SYSTEM_DECL_START1);
		}
		else {
			builder.append(PUBLIC_DECL_START);
			builder.append(_publicId);
			builder.append(SYSTEM_DECL_START2);
		}
		builder.append(_systemId);
		builder.append(DECL_END);
		builder.append(TAG_POSTFIX);
		
		return builder.toString();
	}
	
}
