package jp.sourceforge.talisman;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * <plugin>
 *   <groupId>jp.cafebabe</groupId>
 *   <artifactId>maven-ddlutils-plugin</artifactId>
 *   <configuration>
 *     <platform>derby</platform> <!-- target platform name -->
 *     <outputDirectory>target/schema</outputDirectory> <!-- output directory -->
 *   </configuration>
 * </plugin>
 * 
 * @goal build-ddl
 * @phase process-resources
 */
public class DdlUtilsMojo extends AbstractMojo{
    /**
     * Location of the file.
     * 
     * @parameter default-value="${project.build.directory}/schema"
     */
    private File outputDirectory;

    /**
     * Type of the platform
     * 
     * @parameter
     * @required
     */
    private String platformType;

    /**
     * 
     * @parameter default-value=true
     */
    private boolean dropTableFirst;

    /**
     * list of schema xml files.
     * @parameter
     * @required
     */
    @SuppressWarnings("unchecked")
    private List files; 

    @SuppressWarnings("unchecked")
    public void execute() throws MojoExecutionException{

        if(platformType == null || platformType.length() < 1){
            throw new MojoExecutionException("platformType is missing");
        }
        File f = outputDirectory;
        if(!f.exists()){
            f.mkdirs();
        }
        Platform platform = PlatformFactory.createNewPlatformInstance(platformType);

        DatabaseIO dbio = new DatabaseIO();
        for(Iterator i = files.iterator(); i.hasNext(); ){
            File file = new File((String)i.next());

            Database database = dbio.read(file);
            String createTableDdl = platform.getCreateTablesSql(database, dropTableFirst, true);

            String name = file.getName();
            name = name.substring(0, name.lastIndexOf("."));
            File dest = new File(f, name + ".ddl");

            try{
                FileWriter out = new FileWriter(dest);
                out.write(createTableDdl);
                out.close();
            } catch(IOException e){
                throw new MojoExecutionException(e.getMessage());
            }
        }
    }
}
