/*
 * Decompiled with CFR 0.152.
 */
package tdoclet;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import tdoclet.TestItem;

public class XmlTestRecorder {
    private String fileName;
    private List updateHistory = new ArrayList();

    public XmlTestRecorder(String fileName) {
        this.fileName = fileName;
    }

    public Collection parse() throws ParseException {
        Document document;
        DocumentBuilder builder;
        ArrayList<TestItem> record = new ArrayList<TestItem>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return record;
        }
        File file = new File(this.fileName);
        if (!file.exists()) {
            return record;
        }
        try {
            document = builder.parse("file:" + this.fileName);
        }
        catch (SAXException e) {
            return record;
        }
        catch (IOException e) {
            return record;
        }
        Element top = document.getDocumentElement();
        NodeList updateList = top.getElementsByTagName("update");
        int i = 0;
        while (i < updateList.getLength()) {
            Element update = (Element)updateList.item(i);
            this.updateHistory.add(((Text)update.getFirstChild()).getData());
            ++i;
        }
        NodeList itemList = top.getElementsByTagName("item");
        int i2 = 0;
        while (i2 < itemList.getLength()) {
            Element item = (Element)itemList.item(i2);
            TestItem testItem = TestItem.createTestItemFromElement(item);
            record.add(testItem);
            ++i2;
        }
        return record;
    }

    public List getUpdateHistory() {
        return Collections.unmodifiableList(this.updateHistory);
    }
}

