/*
 * Decompiled with CFR 0.152.
 */
package tdoclet;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import tdoclet.TestItem;
import tdoclet.TestReport;

public class JUnitTestReport
implements TestReport {
    private String reportPath;
    private Map table;

    public JUnitTestReport(String path) {
        this.reportPath = path;
        this.table = new HashMap();
    }

    public int getResult(TestItem item) {
        TestClass testClass = this.getTestClass(item);
        if (testClass == null) {
            return 0;
        }
        TestMethod testMethod = (TestMethod)testClass.methodTable.get(item.getTestMethod());
        if (testMethod == null) {
            return 0;
        }
        return testMethod.result;
    }

    public Date getDate(TestItem item) {
        TestClass testClass = this.getTestClass(item);
        if (testClass == null) {
            return null;
        }
        return testClass.runTime;
    }

    private TestClass getTestClass(TestItem item) {
        String testClassName = item.getTestClass();
        TestClass testClass = (TestClass)this.table.get(testClassName);
        if (testClass != null) {
            return testClass;
        }
        testClass = new TestClass(testClassName);
        this.table.put(testClassName, testClass);
        return testClass;
    }

    private class TestMethod {
        private String name;
        private int result;
        private long time;

        private TestMethod(String name, int result) {
            this.name = name;
            this.result = result;
        }
    }

    private class TestClass {
        private String name;
        private Map methodTable = new HashMap();
        private Date runTime;

        private TestClass(String name) {
            File file = this.getResultXmlFile(name);
            if (!file.exists()) {
                return;
            }
            this.runTime = new Date(file.lastModified());
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(file);
                Element element = document.getDocumentElement();
                NodeList resultsElement = element.getElementsByTagName("testcase");
                int i = 0;
                while (i < resultsElement.getLength()) {
                    TestMethod testMethod = null;
                    Element testCase = (Element)resultsElement.item(i);
                    String methodName = testCase.getAttribute("name");
                    NodeList failureList = testCase.getElementsByTagName("failure");
                    if (failureList.getLength() > 0) {
                        testMethod = new TestMethod(methodName, -1);
                        this.methodTable.put(methodName, testMethod);
                    } else {
                        NodeList errorList = testCase.getElementsByTagName("error");
                        if (errorList.getLength() > 0) {
                            testMethod = new TestMethod(methodName, -2);
                            this.methodTable.put(methodName, testMethod);
                        } else {
                            testMethod = new TestMethod(methodName, 1);
                            this.methodTable.put(methodName, testMethod);
                        }
                    }
                    ++i;
                }
            }
            catch (ParserConfigurationException e) {
            }
            catch (SAXException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }

        private File getResultXmlFile(String name) {
            String fileName = JUnitTestReport.this.reportPath + "TEST-" + name + ".xml";
            return new File(fileName);
        }
    }
}

