/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.browser.ImageResourceManager;
import org.eclipse.ui.internal.browser.Trace;

public class BusyIndicator
extends Canvas {
    protected Image[] images = new Image[13];
    protected Image image;
    protected Thread busyThread;
    protected boolean stop;
    private static final String URL_BUSY = "$nl$/icons/obj16/busy/";

    public BusyIndicator(Composite parent, int style) {
        super(parent, style);
        ImageResourceManager imageManager = new ImageResourceManager((Control)this);
        int i = 0;
        while (i < 13) {
            ImageDescriptor id = ImageResourceManager.getImageDescriptor(URL_BUSY + (i + 1) + ".gif");
            this.images[i] = imageManager.getImage(id);
            ++i;
        }
        this.addPaintListener(this::onPaint);
        this.image = this.images[0];
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(25, 25);
    }

    protected synchronized void createBusyThread() {
        if (this.busyThread != null) {
            return;
        }
        this.stop = false;
        this.busyThread = new Thread(){
            protected int count;

            @Override
            public void run() {
                try {
                    this.count = 1;
                    while (!BusyIndicator.this.stop) {
                        Display.getDefault().syncExec(() -> {
                            if (!BusyIndicator.this.stop) {
                                if (this.count < 13) {
                                    BusyIndicator.this.setImage(BusyIndicator.this.images[this.count]);
                                }
                                ++this.count;
                                if (this.count > 12) {
                                    this.count = 1;
                                }
                            }
                        });
                        try {
                            1.sleep(125L);
                        }
                        catch (Exception exception) {}
                    }
                    if (BusyIndicator.this.busyThread == null) {
                        Display.getDefault().syncExec((Runnable)new Thread(){

                            @Override
                            public void run() {
                                BusyIndicator.this.setImage((this).BusyIndicator.this.images[0]);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Trace.trace(Trace.WARNING, "Busy error", e);
                }
            }
        };
        this.busyThread.setPriority(7);
        this.busyThread.setDaemon(true);
        this.busyThread.start();
    }

    public void dispose() {
        this.stop = true;
        this.busyThread = null;
        super.dispose();
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isBusy() {
        return this.busyThread != null;
    }

    protected void onPaint(PaintEvent event) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        GC gc = event.gc;
        if (this.image != null) {
            gc.drawImage(this.image, 2, 2);
        }
    }

    public synchronized void setBusy(boolean busy) {
        if (busy) {
            if (this.busyThread == null) {
                this.createBusyThread();
            }
        } else if (this.busyThread != null) {
            this.stop = true;
            this.busyThread = null;
        }
    }

    public void setImage(Image image) {
        if (image != this.image && !this.isDisposed()) {
            this.image = image;
            this.redraw();
        }
    }
}

